/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.fragment;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverNamespaceResolver {
    private Stack<XMLElement> elements = new Stack();

    public void push(XMLElement elm) {
        this.elements.push(elm);
    }

    public void pop() {
        this.elements.pop();
    }

    public Map<String, String> getNamespaceDeclarations() {
        LinkedHashMap<String, String> ns = new LinkedHashMap<String, String>();
        if (!this.elements.isEmpty()) {
            XMLElement topElm = this.elements.peek();
            for (Map.Entry<String, String> entry : topElm.getDeclaredNamespaces().entrySet()) {
                ns.put(entry.getKey(), entry.getValue());
            }
            for (Attribute attribute : topElm.getAttributes()) {
                String attrNs = attribute.getNamespaceUri();
                if (attrNs.length() <= 0 || this.resolvePrefix(attrNs, false) != null) continue;
                ns.put(this.resolvePrefix(attrNs), attrNs);
            }
            if (topElm.getNamespaceURI().length() > 0) {
                if (!ns.containsValue(topElm.getNamespaceURI())) {
                    this.pop();
                    if (this.resolvePrefix(topElm.getNamespaceURI(), false) == null) {
                        ns.put(topElm.getNamespacePrefix(), topElm.getNamespaceURI());
                    }
                    this.push(topElm);
                }
            } else if (this.elements.size() > 1 && ((XMLElement)this.elements.get(this.elements.size() - 2)).getNamespaceURI().length() > 0 && !ns.containsKey("")) {
                ns.put("", "");
            }
        }
        return ns;
    }

    public String resolveUri(String prefix) {
        String uri;
        String resolvedPrefix;
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            String uri2 = this.resolveUri((XMLElement)this.elements.get(i), prefix);
            if (uri2 == null) continue;
            return uri2;
        }
        if (!this.elements.isEmpty() && prefix.equals(this.elements.peek().getNamespacePrefix()) && ((resolvedPrefix = this.resolvePrefix(uri = this.elements.peek().getNamespaceURI(), false)) == null || resolvedPrefix.equals(prefix))) {
            return uri;
        }
        return null;
    }

    private String resolveUri(XMLElement elm, String prefix) {
        return elm.getDeclaredNamespaces().get(prefix);
    }

    public String resolvePrefix(String uri) {
        return this.resolvePrefix(uri, true);
    }

    private String resolvePrefix(String uri, boolean generatePrefix) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            String prefix = this.resolvePrefix((XMLElement)this.elements.get(i), uri);
            if (prefix == null) continue;
            return prefix;
        }
        if (!this.elements.isEmpty() && uri.equals(this.elements.peek().getNamespaceURI())) {
            return this.elements.peek().getNamespacePrefix();
        }
        if (generatePrefix) {
            return "ns1";
        }
        return null;
    }

    private String resolvePrefix(XMLElement elm, String uri) {
        for (Map.Entry<String, String> entry : elm.getDeclaredNamespaces().entrySet()) {
            if (!entry.getValue().equals(uri)) continue;
            return entry.getKey();
        }
        return null;
    }
}

