/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.SqlXmlUtil;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.types.XMLDataValue;

public class SqlXmlExecutor {
    private Activation activation;
    private int sqlXUtilId;
    private int targetTypeId;
    private int targetMaxWidth;
    private boolean preserveWS;

    public SqlXmlExecutor(Activation activation, int n, boolean bl) {
        this.activation = activation;
        this.sqlXUtilId = n;
        this.preserveWS = bl;
    }

    public SqlXmlExecutor(int n, int n2) {
        this.targetTypeId = n;
        this.targetMaxWidth = n2;
    }

    public SqlXmlExecutor(Activation activation, int n) {
        this.activation = activation;
        this.sqlXUtilId = n;
    }

    public XMLDataValue XMLParse(StringDataValue stringDataValue, XMLDataValue xMLDataValue) throws StandardException {
        if (xMLDataValue == null) {
            xMLDataValue = new XML();
        }
        if (stringDataValue.isNull()) {
            xMLDataValue.setToNull();
            return xMLDataValue;
        }
        return xMLDataValue.XMLParse(stringDataValue.getString(), this.preserveWS, this.getSqlXmlUtil());
    }

    public StringDataValue XMLSerialize(XMLDataValue xMLDataValue, StringDataValue stringDataValue) throws StandardException {
        return xMLDataValue.XMLSerialize(stringDataValue, this.targetTypeId, this.targetMaxWidth);
    }

    public BooleanDataValue XMLExists(StringDataValue stringDataValue, XMLDataValue xMLDataValue) throws StandardException {
        return xMLDataValue.XMLExists(this.getSqlXmlUtil());
    }

    public XMLDataValue XMLQuery(StringDataValue stringDataValue, XMLDataValue xMLDataValue, XMLDataValue xMLDataValue2) throws StandardException {
        return xMLDataValue.XMLQuery(xMLDataValue2, this.getSqlXmlUtil());
    }

    private SqlXmlUtil getSqlXmlUtil() throws StandardException {
        return (SqlXmlUtil)this.activation.getPreparedStatement().getSavedObject(this.sqlXUtilId);
    }
}

