/*
 * Decompiled with CFR 0.152.
 */
package test.pdfbox.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;

public class TestTextStripper
extends TestCase {
    private boolean bFail = false;
    private PDFTextStripper stripper = new PDFTextStripper();
    static /* synthetic */ Class class$test$pdfbox$util$TestTextStripper;

    public TestTextStripper(String name) throws IOException {
        super(name);
        this.stripper.setLineSeparator("\n");
    }

    public void setUp() {
    }

    private boolean stringsEqual(String expected, String actual) {
        boolean equals = true;
        if (expected == null && actual == null) {
            return true;
        }
        if (expected != null && actual != null) {
            int actualIndex;
            expected = expected.trim();
            actual = actual.trim();
            char[] expectedArray = expected.toCharArray();
            char[] actualArray = actual.toCharArray();
            int expectedIndex = 0;
            for (actualIndex = 0; expectedIndex < expectedArray.length && actualIndex < actualArray.length; ++expectedIndex, ++actualIndex) {
                if (expectedArray[expectedIndex] != actualArray[actualIndex]) {
                    equals = false;
                    System.err.println("Lines differ at index expected:" + expectedIndex + "-" + expectedArray[expectedIndex] + " actual:" + actualIndex + "-" + actualArray[actualIndex]);
                    break;
                }
                expectedIndex = this.skipWhitespace(expectedArray, expectedIndex);
                actualIndex = this.skipWhitespace(actualArray, actualIndex);
            }
            if (equals) {
                if (expectedIndex != expectedArray.length) {
                    equals = false;
                    System.err.println("Expected line is longer at:" + expectedIndex);
                }
                if (actualIndex != actualArray.length) {
                    equals = false;
                    System.err.println("Actual line is longer at:" + actualIndex);
                }
            }
        } else {
            equals = expected == null && actual != null && actual.trim().equals("") || actual == null && expected != null && expected.trim().equals("");
        }
        return equals;
    }

    private int skipWhitespace(char[] array, int index) {
        if (array[index] == ' ' || array[index] > '\u0100') {
            while (index < array.length && (array[index] == ' ' || array[index] > '\u0100')) {
                ++index;
            }
            --index;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTestFile(File file, boolean bLogResult) throws Exception {
        PDDocument document;
        Writer writer;
        OutputStream os;
        block14: {
            block12: {
                block13: {
                    System.out.println("Preparing to parse " + file.getName());
                    os = null;
                    writer = null;
                    document = null;
                    try {
                        String actualLine;
                        String expectedLine;
                        document = PDDocument.load(file);
                        File outFile = new File(file.getParentFile().getParentFile(), "output/" + file.getName() + ".txt");
                        os = new FileOutputStream(outFile);
                        os.write(255);
                        os.write(254);
                        writer = new OutputStreamWriter(os, "UTF-16LE");
                        this.stripper.writeText(document, writer);
                        if (bLogResult) {
                            System.out.println("Text for " + file.getName() + ":\r\n" + this.stripper.getText(document));
                        }
                        File expectedFile = new File(file.getParentFile().getParentFile(), "input/" + file.getName() + ".txt");
                        File actualFile = new File(file.getParentFile().getParentFile(), "output/" + file.getName() + ".txt");
                        if (!expectedFile.exists()) {
                            this.bFail = true;
                            System.err.println("FAILURE: Input verification file: " + expectedFile.getAbsolutePath() + " did not exist");
                            Object var14_9 = null;
                            if (writer == null) break block12;
                            break block13;
                        }
                        LineNumberReader expectedReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(expectedFile), "UTF-16"));
                        LineNumberReader actualReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(actualFile), "UTF-16"));
                        do {
                            expectedLine = expectedReader.readLine();
                            while (expectedLine != null && expectedLine.trim().length() == 0) {
                                expectedLine = expectedReader.readLine();
                            }
                            actualLine = actualReader.readLine();
                            while (actualLine != null && actualLine.trim().length() == 0) {
                                actualLine = actualReader.readLine();
                            }
                            if (this.stringsEqual(expectedLine, actualLine)) continue;
                            this.bFail = true;
                            System.err.println("FAILURE: Line mismatch for file " + file.getName() + " at expected line: " + expectedReader.getLineNumber() + " at actual line: " + actualReader.getLineNumber() + "\r\n  expected line was: \"" + expectedLine + "\"" + "\r\n  actual line was:   \"" + actualLine + "\"");
                        } while (expectedLine != null && actualLine != null);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var14_11 = null;
                        if (writer != null) {
                            writer.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                        if (document == null) throw throwable;
                        document.close();
                        throw throwable;
                    }
                }
                writer.close();
            }
            if (os != null) {
                os.close();
            }
            if (document == null) return;
            document.close();
            return;
        }
        Object var14_10 = null;
        if (writer != null) {
            writer.close();
        }
        if (os != null) {
            os.close();
        }
        if (document == null) return;
        document.close();
    }

    public void testExtract() throws Exception {
        String filename = System.getProperty("test.pdfbox.util.TextStripper.file");
        File testDir = new File("test/input");
        if (filename == null || filename.length() == 0) {
            File[] testFiles = testDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".pdf");
                }
            });
            for (int n = 0; n < testFiles.length; ++n) {
                this.doTestFile(testFiles[n], false);
            }
        } else {
            this.doTestFile(new File(testDir, filename), true);
        }
        if (this.bFail) {
            TestTextStripper.fail((String)"One or more failures, see test log for details");
        }
    }

    public static Test suite() {
        return new TestSuite(class$test$pdfbox$util$TestTextStripper == null ? (class$test$pdfbox$util$TestTextStripper = TestTextStripper.class$("test.pdfbox.util.TestTextStripper")) : class$test$pdfbox$util$TestTextStripper);
    }

    public static void main(String[] args) {
        String[] arg = new String[]{(class$test$pdfbox$util$TestTextStripper == null ? (class$test$pdfbox$util$TestTextStripper = TestTextStripper.class$("test.pdfbox.util.TestTextStripper")) : class$test$pdfbox$util$TestTextStripper).getName()};
        TestRunner.main((String[])arg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

