/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoDTimeInventory {
    private static final Logger logger = LoggerFactory.getLogger(TwoDTimeInventory.class);
    private int nruns;
    private int ntimes;
    private int[] count;

    public TwoDTimeInventory(int nruns, int ntimes) {
        this.nruns = nruns;
        this.ntimes = ntimes;
        this.count = new int[nruns * ntimes];
    }

    public void setAll() {
        for (int idx = 0; idx < this.count.length; ++idx) {
            this.count[idx] = 1;
        }
    }

    public void add(int runIdx, int timeIdx) {
        int idx = runIdx * this.ntimes + timeIdx;
        if (idx >= this.count.length) {
            logger.error("TwoDTimeInventory BAD index get=" + idx + " max= " + this.count.length, new Throwable());
        }
        int n = idx;
        this.count[n] = this.count[n] + 1;
    }

    public void showMissing(Formatter f) {
        int idx = 0;
        for (int row = 0; row < this.nruns; ++row) {
            for (int col = 0; col < this.ntimes; ++col) {
                int n;
                if ((n = this.count[idx++]) == 0) {
                    f.format("-", new Object[0]);
                    continue;
                }
                if (n < 10) {
                    f.format("%1d", n);
                    continue;
                }
                f.format("X", new Object[0]);
            }
            f.format("%n", new Object[0]);
        }
        f.format("%n", new Object[0]);
    }

    public int[] getCount() {
        return this.count;
    }

    public int getCount(int runIdx, int timeIdx) {
        int idx = runIdx * this.ntimes + timeIdx;
        return this.count[idx];
    }

    public TwoDTimeInventory(List<Integer> count) {
        this.count = new int[count.size()];
        int idx = 0;
        for (int n : count) {
            this.count[idx++] = n;
        }
    }

    public void setSize(int nruns, int ntimes) {
        this.nruns = nruns;
        this.ntimes = ntimes;
    }
}

