/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.exolab.castor.builder.ClassInfo;
import org.exolab.castor.builder.DescriptorSourceFactory;
import org.exolab.castor.builder.MappingFileSourceFactory;
import org.exolab.castor.builder.SGStateInfo;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.binding.ExtendedBinding;
import org.exolab.castor.builder.util.ConsoleDialog;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JComment;
import org.exolab.javasource.JNaming;

public class SingleClassGenerator {
    private static final String DEFAULT_HEADER = "This class was automatically generated with \n<a href=\"http://www.castor.org\">Castor 1.0.5</a>, using an XML Schema.\n$Id$";
    private static final String CDR_FILE = ".castor.cdr";
    private boolean _promptForOverwrite = true;
    private String _destDir = null;
    private String _lineSeparator = null;
    private boolean _createDescriptors = true;
    private final JComment _header;
    private final ConsoleDialog _dialog;
    private final DescriptorSourceFactory _descSourceFactory;
    private final MappingFileSourceFactory _mappingSourceFactory;
    private final SourceGenerator _sourceGenerator;

    public SingleClassGenerator(ConsoleDialog dialog, SourceGenerator sourceGenerator) {
        this._dialog = dialog;
        this._sourceGenerator = sourceGenerator;
        this._header = new JComment(3);
        this._header.appendComment(DEFAULT_HEADER);
        this._descSourceFactory = new DescriptorSourceFactory(this._sourceGenerator);
        this._mappingSourceFactory = new MappingFileSourceFactory(this._sourceGenerator);
    }

    public void setDestDir(String destDir) {
        this._destDir = destDir;
    }

    public void setLineSeparator(String lineSeparator) {
        this._lineSeparator = lineSeparator;
    }

    public void setDescriptorCreation(boolean createDescriptors) {
        this._createDescriptors = createDescriptors;
    }

    public void setPromptForOverwrite(boolean promptForOverwrite) {
        this._promptForOverwrite = promptForOverwrite;
    }

    boolean processIfNotAlreadyProcessed(Enumeration classKeys, SGStateInfo state) throws IOException {
        while (classKeys.hasMoreElements()) {
            ClassInfo classInfo = state.resolve(classKeys.nextElement());
            JClass jClass = classInfo.getJClass();
            if (state.processed(jClass)) continue;
            this.process(jClass, state);
            if (state.getStatusCode() != 1) continue;
            return false;
        }
        return true;
    }

    boolean process(JClass[] classes, SGStateInfo state) throws IOException {
        for (int i = 0; i < classes.length; ++i) {
            this.process(classes[i], state);
            if (state.getStatusCode() != 1) continue;
            return false;
        }
        return true;
    }

    boolean process(JClass jClass, SGStateInfo state) throws IOException {
        if (state.getStatusCode() == 1) {
            return false;
        }
        if (state.processed(jClass)) {
            return true;
        }
        this.checkNameNotReserved(jClass.getName(), state);
        ClassInfo classInfo = state.resolve(jClass);
        JClass conflict = state.getProcessed(jClass.getName());
        if (conflict != null && !state.getSuppressNonFatalWarnings()) {
            this.warnAboutClassNameConflict(state, classInfo, conflict);
            return state.getStatusCode() != 1;
        }
        state.markAsProcessed(jClass);
        if (this.checkAllowPrinting(jClass)) {
            jClass.removeImport("org.exolab.castor.types.Date");
            jClass.setHeader(this._header);
            jClass.print(this._destDir, this._lineSeparator);
        }
        if (classInfo != null) {
            this.processClassDescriptor(jClass, state, classInfo);
        }
        return state.getStatusCode() != 1;
    }

    private void processClassDescriptor(JClass jClass, SGStateInfo state, ClassInfo classInfo) throws IOException {
        if (this._createDescriptors) {
            JClass desc = this._descSourceFactory.createSource(classInfo);
            if (this.checkAllowPrinting(desc)) {
                this.updateCDRFile(jClass, desc, state);
                desc.setHeader(this._header);
                desc.print(this._destDir, this._lineSeparator);
            }
        } else {
            MappingRoot mapping;
            String pkg = state._packageName;
            if (pkg == null) {
                pkg = "";
            }
            if ((mapping = state.getMapping(pkg)) == null) {
                mapping = new MappingRoot();
                state.setMapping(pkg, mapping);
            }
            mapping.addClassMapping(this._mappingSourceFactory.createMapping(classInfo));
        }
    }

    private void warnAboutClassNameConflict(SGStateInfo state, ClassInfo newClassInfo, JClass conflict) {
        ClassInfo oldClassInfo = state.resolve(conflict);
        if (oldClassInfo == newClassInfo) {
            return;
        }
        Annotated a1 = null;
        Annotated a2 = null;
        Enumeration enumeration = state.keys();
        while (enumeration.hasMoreElements() && (a1 == null || a2 == null)) {
            Object key = enumeration.nextElement();
            if (!(key instanceof Annotated)) continue;
            ClassInfo cInfo = state.resolve(key);
            if (newClassInfo == cInfo) {
                a1 = (Annotated)key;
                continue;
            }
            if (oldClassInfo != cInfo) continue;
            a2 = (Annotated)key;
        }
        StringBuffer error = new StringBuffer();
        error.append("Warning: A class name generation conflict has occured between ");
        if (a1 != null) {
            error.append(SchemaNames.getStructureName(a1));
            error.append(" '");
            error.append(ExtendedBinding.getSchemaLocation(a1));
        } else {
            error.append(newClassInfo.getNodeTypeName());
            error.append(" '");
            error.append(newClassInfo.getNodeName());
        }
        error.append("' and ");
        if (a2 != null) {
            error.append(SchemaNames.getStructureName(a2));
            error.append(" '");
            error.append(ExtendedBinding.getSchemaLocation(a2));
        } else {
            error.append(oldClassInfo.getNodeTypeName());
            error.append(" '");
            error.append(oldClassInfo.getNodeName());
        }
        error.append("'. Please use a Binding file to solve this problem.");
        error.append("Continue anyway [not recommended] ");
        char ch = this._dialog.confirm(error.toString(), "yn", "y = yes, n = no");
        if (ch == 'n') {
            state.setStatusCode(1);
        }
    }

    private boolean checkAllowPrinting(JClass jClass) {
        if (!this._promptForOverwrite) {
            return true;
        }
        String filename = jClass.getFilename(this._destDir);
        File file = new File(filename);
        if (!file.exists()) {
            return true;
        }
        boolean allowPrinting = true;
        String message = filename + " already exists. overwrite";
        char ch = this._dialog.confirm(message, "yna", "y = yes, n = no, a = all");
        switch (ch) {
            case 'a': {
                this._promptForOverwrite = false;
                allowPrinting = true;
                break;
            }
            case 'y': {
                allowPrinting = true;
                break;
            }
            default: {
                allowPrinting = false;
            }
        }
        return allowPrinting;
    }

    private void checkNameNotReserved(String elementName, SGStateInfo sInfo) {
        if (elementName == null) {
            return;
        }
        String nameToCompare = elementName.substring(0, 1).toUpperCase() + elementName.substring(1);
        if (JNaming.isInJavaLang(nameToCompare)) {
            String err = "'" + nameToCompare + "' conflicts with a class in java.lang.*" + " and cannot be used as a class name.\nYou need to use a mapping" + " file or change the name of the schema element.";
            sInfo.getDialog().notify(err);
            throw new IllegalArgumentException(err);
        }
        if (JNaming.isReservedByCastor(nameToCompare)) {
            String warn = "'" + nameToCompare + "' might conflict with a field name used" + " by Castor.  If you get a complaint\nabout a duplicate name, you will" + " need to use a mapping file or change\nthe name of the conflicting" + " schema element.";
            sInfo.getDialog().notify(warn);
        }
    }

    private void updateCDRFile(JClass jClass, JClass jDesc, SGStateInfo sInfo) throws IOException {
        String entityFilename = jClass.getFilename(this._destDir);
        File file = new File(entityFilename);
        File parentDirectory = file.getParentFile();
        File cdrFile = new File(parentDirectory, CDR_FILE);
        String cdrFilename = cdrFile.getAbsolutePath();
        Properties props = sInfo.getCDRFile(cdrFilename);
        if (props == null) {
            props = new Properties();
            if (cdrFile.exists()) {
                props.load(new FileInputStream(cdrFile));
            }
            sInfo.setCDRFile(cdrFilename, props);
        }
        props.setProperty(jClass.getName(), jDesc.getName());
    }
}

