/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;

public class UidAndRoutingFieldsVisitor
extends FieldsVisitor {
    private String routing;

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if ("_routing".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        if ("_uid".equals(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return this.uid != null && this.routing != null ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
    }

    @Override
    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        if ("_routing".equals(fieldInfo.name)) {
            this.routing = value;
        } else {
            super.stringField(fieldInfo, value);
        }
    }

    public String routing() {
        return this.routing;
    }
}

