/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.service.launcher;

import java.lang.ref.WeakReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ShutdownHookManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ServiceShutdownHook
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceShutdownHook.class);
    private final WeakReference<Service> serviceRef;

    public ServiceShutdownHook(Service service) {
        this.serviceRef = new WeakReference<Service>(service);
    }

    public synchronized void register(int priority) {
        this.unregister();
        ShutdownHookManager.get().addShutdownHook(this, priority);
    }

    public synchronized void unregister() {
        try {
            ShutdownHookManager.get().removeShutdownHook(this);
        }
        catch (IllegalStateException e) {
            LOG.info("Failed to unregister shutdown hook: {}", (Object)e, (Object)e);
        }
    }

    @Override
    public void run() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shutdown() {
        Service service;
        boolean result = false;
        ServiceShutdownHook serviceShutdownHook = this;
        synchronized (serviceShutdownHook) {
            service = (Service)this.serviceRef.get();
            this.serviceRef.clear();
        }
        if (service != null) {
            try {
                service.stop();
                result = true;
            }
            catch (Throwable t) {
                LOG.info("Error stopping {}", (Object)service.getName(), (Object)t);
            }
        }
        return result;
    }
}

