/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.InstanceScope;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroupDir;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.compiler.CompiledST;
import org.stringtemplate.v4.compiler.Compiler;
import org.stringtemplate.v4.compiler.FormalArgument;
import org.stringtemplate.v4.compiler.GroupLexer;
import org.stringtemplate.v4.compiler.GroupParser;
import org.stringtemplate.v4.compiler.STException;
import org.stringtemplate.v4.misc.Aggregate;
import org.stringtemplate.v4.misc.AggregateModelAdaptor;
import org.stringtemplate.v4.misc.ErrorManager;
import org.stringtemplate.v4.misc.ErrorType;
import org.stringtemplate.v4.misc.MapModelAdaptor;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.ObjectModelAdaptor;
import org.stringtemplate.v4.misc.STModelAdaptor;
import org.stringtemplate.v4.misc.TypeRegistry;

public class STGroup {
    public static final String GROUP_FILE_EXTENSION;
    public static final String TEMPLATE_FILE_EXTENSION;
    private static final boolean[] RESERVED_CHARACTERS;
    public static final String DICT_KEY = "key";
    public static final String DEFAULT_KEY = "default";
    public String encoding = "UTF-8";
    protected final List<STGroup> imports = Collections.synchronizedList(new ArrayList());
    protected final List<STGroup> importsToClearOnUnload = Collections.synchronizedList(new ArrayList());
    public char delimiterStartChar = (char)60;
    public char delimiterStopChar = (char)62;
    protected Map<String, CompiledST> templates = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<String, Map<String, Object>> dictionaries = Collections.synchronizedMap(new HashMap());
    protected Map<Class<?>, AttributeRenderer<?>> renderers;
    protected final Map<Class<?>, ModelAdaptor<?>> adaptors;
    protected static final CompiledST NOT_FOUND_ST;
    public static final ErrorManager DEFAULT_ERR_MGR;
    public static boolean verbose;
    public static boolean trackCreationEvents;
    public boolean iterateAcrossValues;
    public static STGroup defaultGroup;
    public ErrorManager errMgr;

    public STGroup() {
        TypeRegistry registry = new TypeRegistry();
        registry.put(Object.class, new ObjectModelAdaptor());
        registry.put(ST.class, new STModelAdaptor());
        registry.put(Map.class, new MapModelAdaptor());
        registry.put(Aggregate.class, new AggregateModelAdaptor());
        this.adaptors = Collections.synchronizedMap(registry);
        this.iterateAcrossValues = false;
        this.errMgr = DEFAULT_ERR_MGR;
    }

    public STGroup(char delimiterStartChar, char delimiterStopChar) {
        TypeRegistry registry = new TypeRegistry();
        registry.put(Object.class, new ObjectModelAdaptor());
        registry.put(ST.class, new STModelAdaptor());
        registry.put(Map.class, new MapModelAdaptor());
        registry.put(Aggregate.class, new AggregateModelAdaptor());
        this.adaptors = Collections.synchronizedMap(registry);
        this.iterateAcrossValues = false;
        this.errMgr = DEFAULT_ERR_MGR;
        this.delimiterStartChar = delimiterStartChar;
        this.delimiterStopChar = delimiterStopChar;
    }

    public ST getInstanceOf(String name) {
        CompiledST c;
        if (name == null) {
            return null;
        }
        if (verbose) {
            System.out.println(this.getName() + ".getInstanceOf(" + name + ")");
        }
        if (name.charAt(0) != '/') {
            name = "/" + name;
        }
        if ((c = this.lookupTemplate(name)) != null) {
            return this.createStringTemplate(c);
        }
        return null;
    }

    protected ST getEmbeddedInstanceOf(Interpreter interp, InstanceScope scope, String name) {
        ST st;
        String fullyQualifiedName = name;
        if (name.charAt(0) != '/') {
            fullyQualifiedName = scope.st.impl.prefix + name;
        }
        if (verbose) {
            System.out.println("getEmbeddedInstanceOf(" + fullyQualifiedName + ")");
        }
        if ((st = this.getInstanceOf(fullyQualifiedName)) == null) {
            this.errMgr.runTimeError(interp, scope, ErrorType.NO_SUCH_TEMPLATE, fullyQualifiedName);
            return this.createStringTemplateInternally(new CompiledST());
        }
        if (trackCreationEvents) {
            st.debugState.newSTEvent = null;
        }
        return st;
    }

    public ST createSingleton(Token templateToken) {
        String template = templateToken.getType() == 5 || templateToken.getType() == 6 ? Misc.strip(templateToken.getText(), 2) : Misc.strip(templateToken.getText(), 1);
        CompiledST impl = this.compile(this.getFileName(), null, null, template, templateToken);
        ST st = this.createStringTemplateInternally(impl);
        st.groupThatCreatedThisInstance = this;
        st.impl.hasFormalArgs = false;
        st.impl.name = "anonymous";
        st.impl.defineImplicitlyDefinedTemplates(this);
        return st;
    }

    public boolean isDefined(String name) {
        return this.lookupTemplate(name) != null;
    }

    public CompiledST lookupTemplate(String name) {
        CompiledST code;
        if (name.charAt(0) != '/') {
            name = "/" + name;
        }
        if (verbose) {
            System.out.println(this.getName() + ".lookupTemplate(" + name + ")");
        }
        if ((code = this.rawGetTemplate(name)) == NOT_FOUND_ST) {
            if (verbose) {
                System.out.println(name + " previously seen as not found");
            }
            return null;
        }
        if (code == null) {
            code = this.load(name);
        }
        if (code == null) {
            code = this.lookupImportedTemplate(name);
        }
        if (code == null) {
            if (verbose) {
                System.out.println(name + " recorded not found");
            }
            this.templates.put(name, NOT_FOUND_ST);
        }
        if (verbose && code != null) {
            System.out.println(this.getName() + ".lookupTemplate(" + name + ") found");
        }
        return code;
    }

    public synchronized void unload() {
        this.templates.clear();
        this.dictionaries.clear();
        for (STGroup imp : this.imports) {
            imp.unload();
        }
        for (STGroup imp : this.importsToClearOnUnload) {
            this.imports.remove(imp);
        }
        this.importsToClearOnUnload.clear();
    }

    protected CompiledST load(String name) {
        return null;
    }

    public void load() {
    }

    public static boolean isReservedCharacter(char c) {
        return c >= '\u0000' && c < RESERVED_CHARACTERS.length && RESERVED_CHARACTERS[c];
    }

    protected CompiledST lookupImportedTemplate(String name) {
        if (this.imports.size() == 0) {
            return null;
        }
        for (STGroup g : this.imports) {
            CompiledST code;
            if (verbose) {
                System.out.println("checking " + g.getName() + " for imported " + name);
            }
            if ((code = g.lookupTemplate(name)) == null) continue;
            if (verbose) {
                System.out.println(g.getName() + ".lookupImportedTemplate(" + name + ") found");
            }
            return code;
        }
        if (verbose) {
            System.out.println(name + " not found in " + this.getName() + " imports");
        }
        return null;
    }

    public CompiledST rawGetTemplate(String name) {
        return this.templates.get(name);
    }

    public Map<String, Object> rawGetDictionary(String name) {
        return this.dictionaries.get(name);
    }

    public boolean isDictionary(String name) {
        return this.dictionaries.get(name) != null;
    }

    public CompiledST defineTemplate(String templateName, String template) {
        if (templateName.charAt(0) != '/') {
            templateName = "/" + templateName;
        }
        try {
            CompiledST impl = this.defineTemplate(templateName, (Token)new CommonToken(9, templateName), null, template, null);
            return impl;
        }
        catch (STException sTException) {
            return null;
        }
    }

    public CompiledST defineTemplate(String name, String argsS, String template) {
        if (name.charAt(0) != '/') {
            name = "/" + name;
        }
        String[] args = argsS.split(",");
        ArrayList<FormalArgument> a = new ArrayList<FormalArgument>();
        for (String arg : args) {
            a.add(new FormalArgument(arg));
        }
        return this.defineTemplate(name, (Token)new CommonToken(9, name), a, template, null);
    }

    public CompiledST defineTemplate(String fullyQualifiedTemplateName, Token nameT, List<FormalArgument> args, String template, Token templateToken) {
        if (verbose) {
            System.out.println("defineTemplate(" + fullyQualifiedTemplateName + ")");
        }
        if (fullyQualifiedTemplateName == null || fullyQualifiedTemplateName.length() == 0) {
            throw new IllegalArgumentException("empty template name");
        }
        if (fullyQualifiedTemplateName.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in template names");
        }
        template = Misc.trimOneStartingNewline(template);
        template = Misc.trimOneTrailingNewline(template);
        CompiledST code = this.compile(this.getFileName(), fullyQualifiedTemplateName, args, template, templateToken);
        code.name = fullyQualifiedTemplateName;
        this.rawDefineTemplate(fullyQualifiedTemplateName, code, nameT);
        code.defineArgDefaultValueTemplates(this);
        code.defineImplicitlyDefinedTemplates(this);
        return code;
    }

    public CompiledST defineTemplateAlias(Token aliasT, Token targetT) {
        String alias = aliasT.getText();
        String target = targetT.getText();
        CompiledST targetCode = this.rawGetTemplate("/" + target);
        if (targetCode == null) {
            this.errMgr.compileTimeError(ErrorType.ALIAS_TARGET_UNDEFINED, null, aliasT, alias, target);
            return null;
        }
        this.rawDefineTemplate("/" + alias, targetCode, aliasT);
        return targetCode;
    }

    public CompiledST defineRegion(String enclosingTemplateName, Token regionT, String template, Token templateToken) {
        String name = regionT.getText();
        template = Misc.trimOneStartingNewline(template);
        template = Misc.trimOneTrailingNewline(template);
        CompiledST code = this.compile(this.getFileName(), enclosingTemplateName, null, template, templateToken);
        String mangled = STGroup.getMangledRegionName(enclosingTemplateName, name);
        if (this.lookupTemplate(mangled) == null) {
            this.errMgr.compileTimeError(ErrorType.NO_SUCH_REGION, templateToken, regionT, enclosingTemplateName, name);
            return new CompiledST();
        }
        code.name = mangled;
        code.isRegion = true;
        code.regionDefType = ST.RegionType.EXPLICIT;
        code.templateDefStartToken = regionT;
        this.rawDefineTemplate(mangled, code, regionT);
        code.defineArgDefaultValueTemplates(this);
        code.defineImplicitlyDefinedTemplates(this);
        return code;
    }

    public void defineTemplateOrRegion(String fullyQualifiedTemplateName, String regionSurroundingTemplateName, Token templateToken, String template, Token nameToken, List<FormalArgument> args) {
        try {
            if (regionSurroundingTemplateName != null) {
                this.defineRegion(regionSurroundingTemplateName, nameToken, template, templateToken);
            } else {
                this.defineTemplate(fullyQualifiedTemplateName, nameToken, args, template, templateToken);
            }
        }
        catch (STException sTException) {
            // empty catch block
        }
    }

    public void rawDefineTemplate(String name, CompiledST code, Token defT) {
        CompiledST prev = this.rawGetTemplate(name);
        if (prev != null) {
            if (!prev.isRegion) {
                this.errMgr.compileTimeError(ErrorType.TEMPLATE_REDEFINITION, null, defT);
                return;
            }
            if (code.regionDefType != ST.RegionType.IMPLICIT && prev.regionDefType == ST.RegionType.EMBEDDED) {
                this.errMgr.compileTimeError(ErrorType.EMBEDDED_REGION_REDEFINITION, null, defT, STGroup.getUnMangledTemplateName(name));
                return;
            }
            if (code.regionDefType == ST.RegionType.IMPLICIT || prev.regionDefType == ST.RegionType.EXPLICIT) {
                this.errMgr.compileTimeError(ErrorType.REGION_REDEFINITION, null, defT, STGroup.getUnMangledTemplateName(name));
                return;
            }
        }
        code.nativeGroup = this;
        code.templateDefStartToken = defT;
        this.templates.put(name, code);
    }

    public void undefineTemplate(String name) {
        this.templates.remove(name);
    }

    public CompiledST compile(String srcName, String name, List<FormalArgument> args, String template, Token templateToken) {
        Compiler c = new Compiler(this);
        return c.compile(srcName, name, args, template, templateToken);
    }

    public static String getMangledRegionName(String enclosingTemplateName, String name) {
        if (enclosingTemplateName.charAt(0) != '/') {
            enclosingTemplateName = '/' + enclosingTemplateName;
        }
        return "/region__" + enclosingTemplateName + "__" + name;
    }

    public static String getUnMangledTemplateName(String mangledName) {
        String t = mangledName.substring("/region__".length(), mangledName.lastIndexOf("__"));
        String r = mangledName.substring(mangledName.lastIndexOf("__") + 2, mangledName.length());
        return t + '.' + r;
    }

    public void defineDictionary(String name, Map<String, Object> mapping) {
        this.dictionaries.put(name, mapping);
    }

    public void importTemplates(STGroup g) {
        this.importTemplates(g, false);
    }

    public void importTemplates(Token fileNameToken) {
        URL fileUnderRoot;
        String fileName;
        if (verbose) {
            System.out.println("importTemplates(" + fileNameToken.getText() + ")");
        }
        if ((fileName = fileNameToken.getText()) == null || fileName.equals("<missing STRING>")) {
            return;
        }
        fileName = Misc.strip(fileName, 1);
        boolean isGroupFile = fileName.endsWith(GROUP_FILE_EXTENSION);
        boolean isTemplateFile = fileName.endsWith(TEMPLATE_FILE_EXTENSION);
        boolean isGroupDir = !isGroupFile && !isTemplateFile;
        STGroup g = null;
        URL thisRoot = this.getRootDirURL();
        try {
            fileUnderRoot = new URL(thisRoot + "/" + fileName);
        }
        catch (MalformedURLException mfe) {
            this.errMgr.internalError(null, "can't build URL for " + thisRoot + "/" + fileName, mfe);
            return;
        }
        if (isTemplateFile) {
            g = new STGroup(this.delimiterStartChar, this.delimiterStopChar);
            g.setListener(this.getListener());
            URL fileURL = Misc.urlExists(fileUnderRoot) ? fileUnderRoot : this.getURL(fileName);
            if (fileURL != null) {
                try {
                    InputStream s = fileURL.openStream();
                    ANTLRInputStream templateStream = new ANTLRInputStream(s, this.encoding);
                    templateStream.name = fileName;
                    CompiledST code = g.loadTemplateFile("/", fileName, (CharStream)templateStream);
                    if (code == null) {
                        g = null;
                    }
                }
                catch (IOException ioe) {
                    this.errMgr.internalError(null, "can't read from " + fileURL, ioe);
                    g = null;
                }
            } else {
                g = null;
            }
        } else if (isGroupFile) {
            if (Misc.urlExists(fileUnderRoot)) {
                g = new STGroupFile(fileUnderRoot, this.encoding, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            } else {
                g = new STGroupFile(fileName, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            }
        } else if (isGroupDir) {
            if (Misc.urlExists(fileUnderRoot)) {
                g = new STGroupDir(fileUnderRoot, this.encoding, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            } else {
                g = new STGroupDir(fileName, this.delimiterStartChar, this.delimiterStopChar);
                g.setListener(this.getListener());
            }
        }
        if (g == null) {
            this.errMgr.compileTimeError(ErrorType.CANT_IMPORT, null, fileNameToken, fileName);
        } else {
            this.importTemplates(g, true);
        }
    }

    protected void importTemplates(STGroup g, boolean clearOnUnload) {
        if (g == null) {
            return;
        }
        this.imports.add(g);
        if (clearOnUnload) {
            this.importsToClearOnUnload.add(g);
        }
    }

    public List<STGroup> getImportedGroups() {
        return this.imports;
    }

    public void loadGroupFile(String prefix, String fileName) {
        if (verbose) {
            System.out.println(this.getClass().getSimpleName() + ".loadGroupFile(group-file-prefix=" + prefix + ", fileName=" + fileName + ")");
        }
        try {
            URL f = new URL(fileName);
            ANTLRInputStream fs = new ANTLRInputStream(f.openStream(), this.encoding);
            GroupLexer lexer = new GroupLexer((CharStream)fs);
            fs.name = fileName;
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            GroupParser parser = new GroupParser((TokenStream)tokens);
            parser.group(this, prefix);
        }
        catch (Exception e) {
            this.errMgr.IOError(null, ErrorType.CANT_LOAD_GROUP_FILE, e, fileName);
        }
    }

    public CompiledST loadAbsoluteTemplateFile(String fileName) {
        ANTLRFileStream fs;
        try {
            fs = new ANTLRFileStream(fileName, this.encoding);
            fs.name = fileName;
        }
        catch (IOException ioe) {
            return null;
        }
        return this.loadTemplateFile("", fileName, (CharStream)fs);
    }

    public CompiledST loadTemplateFile(String prefix, String unqualifiedFileName, CharStream templateStream) {
        GroupLexer lexer = new GroupLexer(templateStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GroupParser parser = new GroupParser((TokenStream)tokens);
        parser.group = this;
        lexer.group = this;
        try {
            parser.templateDef(prefix);
        }
        catch (RecognitionException re) {
            this.errMgr.groupSyntaxError(ErrorType.SYNTAX_ERROR, unqualifiedFileName, re, re.getMessage());
        }
        String templateName = Misc.getFileNameNoSuffix(unqualifiedFileName);
        if (prefix != null && prefix.length() > 0) {
            templateName = prefix + templateName;
        }
        CompiledST impl = this.rawGetTemplate(templateName);
        impl.prefix = prefix;
        return impl;
    }

    public <T> void registerModelAdaptor(Class<T> attributeType, ModelAdaptor<? super T> adaptor) {
        if (attributeType.isPrimitive()) {
            throw new IllegalArgumentException("can't register ModelAdaptor for primitive type " + attributeType.getSimpleName());
        }
        this.adaptors.put(attributeType, adaptor);
    }

    public <T> ModelAdaptor<? super T> getModelAdaptor(Class<T> attributeType) {
        return this.adaptors.get(attributeType);
    }

    public <T> void registerRenderer(Class<T> attributeType, AttributeRenderer<? super T> r) {
        this.registerRenderer(attributeType, r, true);
    }

    public <T> void registerRenderer(Class<T> attributeType, AttributeRenderer<? super T> r, boolean recursive) {
        if (attributeType.isPrimitive()) {
            throw new IllegalArgumentException("can't register renderer for primitive type " + attributeType.getSimpleName());
        }
        if (this.renderers == null) {
            this.renderers = Collections.synchronizedMap(new TypeRegistry());
        }
        this.renderers.put(attributeType, r);
        if (recursive) {
            this.load();
            for (STGroup g : this.imports) {
                g.registerRenderer(attributeType, r, true);
            }
        }
    }

    public <T> AttributeRenderer<? super T> getAttributeRenderer(Class<T> attributeType) {
        if (this.renderers == null) {
            return null;
        }
        return this.renderers.get(attributeType);
    }

    public ST createStringTemplate(CompiledST impl) {
        ST st = new ST();
        st.impl = impl;
        st.groupThatCreatedThisInstance = this;
        if (impl.formalArguments != null) {
            st.locals = new Object[impl.formalArguments.size()];
            Arrays.fill(st.locals, ST.EMPTY_ATTR);
        }
        return st;
    }

    public ST createStringTemplateInternally(CompiledST impl) {
        ST st = this.createStringTemplate(impl);
        if (trackCreationEvents && st.debugState != null) {
            st.debugState.newSTEvent = null;
        }
        return st;
    }

    public ST createStringTemplateInternally(ST proto) {
        return new ST(proto);
    }

    public String getName() {
        return "<no name>;";
    }

    public String getFileName() {
        return null;
    }

    public URL getRootDirURL() {
        return null;
    }

    public URL getURL(String fileName) {
        URL url = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            url = cl.getResource(fileName);
        }
        if (url == null && (cl = this.getClass().getClassLoader()) != null) {
            url = cl.getResource(fileName);
        }
        return url;
    }

    public String toString() {
        return this.getName();
    }

    public String show() {
        StringBuilder buf = new StringBuilder();
        if (this.imports.size() != 0) {
            buf.append(" : " + this.imports);
        }
        for (String name : this.templates.keySet()) {
            CompiledST c = this.rawGetTemplate(name);
            if (c.isAnonSubtemplate || c == NOT_FOUND_ST) continue;
            int slash = name.lastIndexOf(47);
            name = name.substring(slash + 1, name.length());
            buf.append(name);
            buf.append('(');
            if (c.formalArguments != null) {
                buf.append(Misc.join(c.formalArguments.values().iterator(), ","));
            }
            buf.append(')');
            buf.append(" ::= <<" + Misc.newline);
            buf.append(c.template + Misc.newline);
            buf.append(">>" + Misc.newline);
        }
        return buf.toString();
    }

    public STErrorListener getListener() {
        return this.errMgr.listener;
    }

    public void setListener(STErrorListener listener) {
        this.errMgr = new ErrorManager(listener);
    }

    public Set<String> getTemplateNames() {
        this.load();
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, CompiledST> e : this.templates.entrySet()) {
            if (e.getValue() == NOT_FOUND_ST) continue;
            result.add(e.getKey());
        }
        return result;
    }

    static {
        int c;
        GROUP_FILE_EXTENSION = ".stg";
        TEMPLATE_FILE_EXTENSION = ".st";
        RESERVED_CHARACTERS = new boolean[127];
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            STGroup.RESERVED_CHARACTERS[c] = true;
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            STGroup.RESERVED_CHARACTERS[c] = true;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            STGroup.RESERVED_CHARACTERS[c] = true;
        }
        STGroup.RESERVED_CHARACTERS[64] = true;
        STGroup.RESERVED_CHARACTERS[45] = true;
        STGroup.RESERVED_CHARACTERS[95] = true;
        STGroup.RESERVED_CHARACTERS[91] = true;
        STGroup.RESERVED_CHARACTERS[93] = true;
        NOT_FOUND_ST = new CompiledST();
        DEFAULT_ERR_MGR = new ErrorManager();
        verbose = false;
        trackCreationEvents = false;
        defaultGroup = new STGroup();
    }
}

