/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import org.apache.directory.api.ldap.model.message.UnbindRequest;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnbindRequestHandler
extends LdapRequestHandler<UnbindRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(UnbindRequestHandler.class);

    @Override
    public void handle(LdapSession session, UnbindRequest unbindRequest) throws Exception {
        LOG.debug("Received: {}", (Object)unbindRequest);
        try {
            session.closeAllPagedSearches();
            session.getCoreSession().unbind(unbindRequest);
            session.getIoSession().closeNow();
            this.ldapServer.getLdapSessionManager().removeLdapSession(session.getIoSession());
        }
        catch (Throwable t) {
            LOG.error(I18n.err((I18n)I18n.ERR_169, (Object[])new Object[0]), t);
        }
    }
}

