/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.identityasserter.common.filter;

import java.io.IOException;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.knox.gateway.IdentityAsserterMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.identityasserter.common.filter.AbstractIdentityAssertionFilter;
import org.apache.knox.gateway.identityasserter.common.filter.IdentityAsserterHttpServletRequestWrapper;
import org.apache.knox.gateway.security.principal.PrincipalMappingException;
import org.apache.knox.gateway.security.principal.SimplePrincipalMapper;

public class CommonIdentityAssertionFilter
extends AbstractIdentityAssertionFilter {
    private IdentityAsserterMessages LOG = (IdentityAsserterMessages)MessagesFactory.get(IdentityAsserterMessages.class);
    public static final String GROUP_PRINCIPAL_MAPPING = "group.principal.mapping";
    public static final String PRINCIPAL_MAPPING = "principal.mapping";
    private SimplePrincipalMapper mapper = new SimplePrincipalMapper();

    public void init(FilterConfig filterConfig) throws ServletException {
        String groupPrincipalMapping;
        String principalMapping = filterConfig.getInitParameter(PRINCIPAL_MAPPING);
        if (principalMapping == null || principalMapping.isEmpty()) {
            principalMapping = filterConfig.getServletContext().getInitParameter(PRINCIPAL_MAPPING);
        }
        if ((groupPrincipalMapping = filterConfig.getInitParameter(GROUP_PRINCIPAL_MAPPING)) == null || groupPrincipalMapping.isEmpty()) {
            groupPrincipalMapping = filterConfig.getServletContext().getInitParameter(GROUP_PRINCIPAL_MAPPING);
        }
        if (principalMapping != null && !principalMapping.isEmpty() || groupPrincipalMapping != null && !groupPrincipalMapping.isEmpty()) {
            try {
                this.mapper.loadMappingTable(principalMapping, groupPrincipalMapping);
            }
            catch (PrincipalMappingException e) {
                throw new ServletException("Unable to load principal mapping table.", (Throwable)e);
            }
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            this.LOG.subjectNotAvailable();
            throw new IllegalStateException("Required Subject Missing");
        }
        String principalName = this.getPrincipalName(subject);
        String mappedPrincipalName = this.mapUserPrincipalBase(principalName);
        mappedPrincipalName = this.mapUserPrincipal(mappedPrincipalName);
        String[] mappedGroups = this.mapGroupPrincipalsBase(mappedPrincipalName, subject);
        String[] groups = this.mapGroupPrincipals(mappedPrincipalName, subject);
        groups = this.combineGroupMappings(mappedGroups, groups);
        HttpServletRequestWrapper wrapper = this.wrapHttpServletRequest(request, mappedPrincipalName);
        this.continueChainAsPrincipal(wrapper, response, chain, mappedPrincipalName, groups);
    }

    protected String[] combineGroupMappings(String[] mappedGroups, String[] groups) {
        if (mappedGroups != null && groups != null) {
            return (String[])ArrayUtils.addAll((Object[])mappedGroups, (Object[])groups);
        }
        return groups != null ? groups : mappedGroups;
    }

    public HttpServletRequestWrapper wrapHttpServletRequest(ServletRequest request, String mappedPrincipalName) {
        return new IdentityAsserterHttpServletRequestWrapper((HttpServletRequest)request, mappedPrincipalName);
    }

    protected String[] mapGroupPrincipalsBase(String mappedPrincipalName, Subject subject) {
        return this.mapper.mapGroupPrincipal(mappedPrincipalName);
    }

    protected String mapUserPrincipalBase(String principalName) {
        return this.mapper.mapUserPrincipal(principalName);
    }

    @Override
    public String[] mapGroupPrincipals(String mappedPrincipalName, Subject subject) {
        return null;
    }

    @Override
    public String mapUserPrincipal(String principalName) {
        return principalName;
    }
}

