/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHostCertInfo;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Arguments to generate a Cloudera Manager Certificate Authority (CMCA).")
public class ApiGenerateCmcaArguments {
    @SerializedName(value="sshPort")
    private BigDecimal sshPort = null;
    @SerializedName(value="userName")
    private String userName = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="privateKey")
    private String privateKey = null;
    @SerializedName(value="passphrase")
    private String passphrase = null;
    @SerializedName(value="location")
    private String location = null;
    @SerializedName(value="customCA")
    private Boolean customCA = null;
    @SerializedName(value="interpretAsFilenames")
    private Boolean interpretAsFilenames = null;
    @SerializedName(value="cmHostCert")
    private String cmHostCert = null;
    @SerializedName(value="cmHostKey")
    private String cmHostKey = null;
    @SerializedName(value="caCert")
    private String caCert = null;
    @SerializedName(value="keystorePasswd")
    private String keystorePasswd = null;
    @SerializedName(value="truststorePasswd")
    private String truststorePasswd = null;
    @SerializedName(value="trustedCaCerts")
    private String trustedCaCerts = null;
    @SerializedName(value="hostCerts")
    private List<ApiHostCertInfo> hostCerts = null;
    @SerializedName(value="configureAllServices")
    private Boolean configureAllServices = null;

    public ApiGenerateCmcaArguments sshPort(BigDecimal sshPort) {
        this.sshPort = sshPort;
        return this;
    }

    @ApiModelProperty(example="22.0", value="SSH port. If unset, defaults to 22.")
    public BigDecimal getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(BigDecimal sshPort) {
        this.sshPort = sshPort;
    }

    public ApiGenerateCmcaArguments userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(value="The username used to authenticate with the hosts. Root access to your hosts is required to install Cloudera packages. The installer will connect to your hosts via SSH and log in either directly as root or as another user with password-less sudo privileges to become root.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ApiGenerateCmcaArguments password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="The password used to authenticate with the hosts. Specify either this or a private key. For password-less login, use an empty string as password.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ApiGenerateCmcaArguments privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @ApiModelProperty(value="The private key to authenticate with the hosts. Specify either this or a password. <br> The private key, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN RSA PRIVATE KEY-----\\n[base-64 encoded key]\\n-----END RSA PRIVATE KEY----- <br>")
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public ApiGenerateCmcaArguments passphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    @ApiModelProperty(value="The passphrase associated with the private key used to authenticate with the hosts (optional).")
    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public ApiGenerateCmcaArguments location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="/opt/cloudera/CMCA", value="The location on disk to store the CMCA directory. If there is already a CMCA created there, it will be backed up, and a new one will be created in its place.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public ApiGenerateCmcaArguments customCA(Boolean customCA) {
        this.customCA = customCA;
        return this;
    }

    @ApiModelProperty(example="false", value="Whether to generate an internal CMCA (false) or use user-provided certificates (true).  When set to true (user-provided certificates), the following other arguments must be given: * cmHostCert * cmHostKey * caCert * keystorePasswd * truststorePasswd")
    public Boolean getCustomCA() {
        return this.customCA;
    }

    public void setCustomCA(Boolean customCA) {
        this.customCA = customCA;
    }

    public ApiGenerateCmcaArguments interpretAsFilenames(Boolean interpretAsFilenames) {
        this.interpretAsFilenames = interpretAsFilenames;
        return this;
    }

    @ApiModelProperty(example="true", value="Whether the following arguments are interpreted as filenames local to the Cloudera Manager host (true, default) or as the actual data for that argument: * cmHostCert * cmHostKey * caCert * keystorePasswd * truststorePasswd * trustedCaCerts * hostCerts.hostCert * hostCerts.hostKey  If HTTPS has not been enabled on the Cloudera Manager Admin Console and API, we *strongly* recommend that you pass the arguments as filenames local to the Cloudera Manager host (i.e. set to true) to avoid leaking sensitive information over the wire in plaintext.")
    public Boolean getInterpretAsFilenames() {
        return this.interpretAsFilenames;
    }

    public void setInterpretAsFilenames(Boolean interpretAsFilenames) {
        this.interpretAsFilenames = interpretAsFilenames;
    }

    public ApiGenerateCmcaArguments cmHostCert(String cmHostCert) {
        this.cmHostCert = cmHostCert;
        return this;
    }

    @ApiModelProperty(example="host-cert.pem", value="The certificate for the CM host in PEM format. Only used if customCA == true.")
    public String getCmHostCert() {
        return this.cmHostCert;
    }

    public void setCmHostCert(String cmHostCert) {
        this.cmHostCert = cmHostCert;
    }

    public ApiGenerateCmcaArguments cmHostKey(String cmHostKey) {
        this.cmHostKey = cmHostKey;
        return this;
    }

    @ApiModelProperty(example="host-key.pem", value="The private key for the CM host in PEM format. Only used if customCA == true.")
    public String getCmHostKey() {
        return this.cmHostKey;
    }

    public void setCmHostKey(String cmHostKey) {
        this.cmHostKey = cmHostKey;
    }

    public ApiGenerateCmcaArguments caCert(String caCert) {
        this.caCert = caCert;
        return this;
    }

    @ApiModelProperty(example="ca-cert.pem", value="The certificate for the user-provided certificate authority in PEM format. Only used if customCA == true.")
    public String getCaCert() {
        return this.caCert;
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public ApiGenerateCmcaArguments keystorePasswd(String keystorePasswd) {
        this.keystorePasswd = keystorePasswd;
        return this;
    }

    @ApiModelProperty(example="keystore.pw.txt", value="The password used for all Auto-TLS keystores. Only used if customCA == true.")
    public String getKeystorePasswd() {
        return this.keystorePasswd;
    }

    public void setKeystorePasswd(String keystorePasswd) {
        this.keystorePasswd = keystorePasswd;
    }

    public ApiGenerateCmcaArguments truststorePasswd(String truststorePasswd) {
        this.truststorePasswd = truststorePasswd;
        return this;
    }

    @ApiModelProperty(example="truststore.pw.txt", value="The password used for all Auto-TLS truststores. Only used if customCA == true.")
    public String getTruststorePasswd() {
        return this.truststorePasswd;
    }

    public void setTruststorePasswd(String truststorePasswd) {
        this.truststorePasswd = truststorePasswd;
    }

    public ApiGenerateCmcaArguments trustedCaCerts(String trustedCaCerts) {
        this.trustedCaCerts = trustedCaCerts;
        return this;
    }

    @ApiModelProperty(example="cacerts.pem", value="A list of CA certificates that will be imported into the Auto-TLS truststore and distributed to all hosts.")
    public String getTrustedCaCerts() {
        return this.trustedCaCerts;
    }

    public void setTrustedCaCerts(String trustedCaCerts) {
        this.trustedCaCerts = trustedCaCerts;
    }

    public ApiGenerateCmcaArguments hostCerts(List<ApiHostCertInfo> hostCerts) {
        this.hostCerts = hostCerts;
        return this;
    }

    public ApiGenerateCmcaArguments addHostCertsItem(ApiHostCertInfo hostCertsItem) {
        if (this.hostCerts == null) {
            this.hostCerts = new ArrayList<ApiHostCertInfo>();
        }
        this.hostCerts.add(hostCertsItem);
        return this;
    }

    @ApiModelProperty(value="A list of HostCertInfo objects, which associate a hostname with the corresponding certificate and private key. Only used if customCA == true.")
    public List<ApiHostCertInfo> getHostCerts() {
        return this.hostCerts;
    }

    public void setHostCerts(List<ApiHostCertInfo> hostCerts) {
        this.hostCerts = hostCerts;
    }

    public ApiGenerateCmcaArguments configureAllServices(Boolean configureAllServices) {
        this.configureAllServices = configureAllServices;
        return this;
    }

    @ApiModelProperty(value="Whether to configure all existing services to use Auto-TLS. If false, only MGMT services will be configured to use Auto-TLS. Use the cluster-level ConfigureAutoTlsServices command to configure Auto-TLS services for a single cluster only.  All future services will be configured to use Auto-TLS regardless of this setting.")
    public Boolean getConfigureAllServices() {
        return this.configureAllServices;
    }

    public void setConfigureAllServices(Boolean configureAllServices) {
        this.configureAllServices = configureAllServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiGenerateCmcaArguments apiGenerateCmcaArguments = (ApiGenerateCmcaArguments)o;
        return Objects.equals(this.sshPort, apiGenerateCmcaArguments.sshPort) && Objects.equals(this.userName, apiGenerateCmcaArguments.userName) && Objects.equals(this.password, apiGenerateCmcaArguments.password) && Objects.equals(this.privateKey, apiGenerateCmcaArguments.privateKey) && Objects.equals(this.passphrase, apiGenerateCmcaArguments.passphrase) && Objects.equals(this.location, apiGenerateCmcaArguments.location) && Objects.equals(this.customCA, apiGenerateCmcaArguments.customCA) && Objects.equals(this.interpretAsFilenames, apiGenerateCmcaArguments.interpretAsFilenames) && Objects.equals(this.cmHostCert, apiGenerateCmcaArguments.cmHostCert) && Objects.equals(this.cmHostKey, apiGenerateCmcaArguments.cmHostKey) && Objects.equals(this.caCert, apiGenerateCmcaArguments.caCert) && Objects.equals(this.keystorePasswd, apiGenerateCmcaArguments.keystorePasswd) && Objects.equals(this.truststorePasswd, apiGenerateCmcaArguments.truststorePasswd) && Objects.equals(this.trustedCaCerts, apiGenerateCmcaArguments.trustedCaCerts) && Objects.equals(this.hostCerts, apiGenerateCmcaArguments.hostCerts) && Objects.equals(this.configureAllServices, apiGenerateCmcaArguments.configureAllServices);
    }

    public int hashCode() {
        return Objects.hash(this.sshPort, this.userName, this.password, this.privateKey, this.passphrase, this.location, this.customCA, this.interpretAsFilenames, this.cmHostCert, this.cmHostKey, this.caCert, this.keystorePasswd, this.truststorePasswd, this.trustedCaCerts, this.hostCerts, this.configureAllServices);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiGenerateCmcaArguments {\n");
        sb.append("    sshPort: ").append(this.toIndentedString(this.sshPort)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    passphrase: ").append(this.toIndentedString(this.passphrase)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    customCA: ").append(this.toIndentedString(this.customCA)).append("\n");
        sb.append("    interpretAsFilenames: ").append(this.toIndentedString(this.interpretAsFilenames)).append("\n");
        sb.append("    cmHostCert: ").append(this.toIndentedString(this.cmHostCert)).append("\n");
        sb.append("    cmHostKey: ").append(this.toIndentedString(this.cmHostKey)).append("\n");
        sb.append("    caCert: ").append(this.toIndentedString(this.caCert)).append("\n");
        sb.append("    keystorePasswd: ").append(this.toIndentedString(this.keystorePasswd)).append("\n");
        sb.append("    truststorePasswd: ").append(this.toIndentedString(this.truststorePasswd)).append("\n");
        sb.append("    trustedCaCerts: ").append(this.toIndentedString(this.trustedCaCerts)).append("\n");
        sb.append("    hostCerts: ").append(this.toIndentedString(this.hostCerts)).append("\n");
        sb.append("    configureAllServices: ").append(this.toIndentedString(this.configureAllServices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

