/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.session;

import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.service.session.SessionInformation;
import org.apache.knox.gateway.service.session.SessionServiceMessages;

@Singleton
@Path(value="session/api/v1/")
public class SessionResource {
    private static final SessionServiceMessages LOG = (SessionServiceMessages)MessagesFactory.get(SessionServiceMessages.class);
    @Context
    HttpServletRequest request;
    @Context
    ServletContext context;

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="sessioninfo")
    public SessionInformation getSessionInformation() {
        SessionInformation sessionInfo = new SessionInformation();
        sessionInfo.setUser(SubjectUtils.getCurrentEffectivePrincipalName());
        GatewayConfig config = (GatewayConfig)this.context.getAttribute("org.apache.knox.gateway.config");
        if (config != null && config.homePageLogoutEnabled()) {
            String logoutUrl = this.getBaseGatewayUrl(config) + "/homepage/knoxssout/api/v1/webssout";
            LOG.homePageLogoutEnabled(logoutUrl);
            sessionInfo.setLogoutUrl(logoutUrl);
            sessionInfo.setLogoutPageUrl(this.getLogoutPageUrl(config));
            sessionInfo.setGlobalLogoutPageUrl(this.getGlobalLogoutPageUrl(config));
        }
        return sessionInfo;
    }

    private String getBaseGatewayUrl(GatewayConfig config) {
        return this.request.getRequestURL().substring(0, this.request.getRequestURL().length() - this.request.getRequestURI().length()) + "/" + config.getGatewayPath();
    }

    private String getLogoutPageUrl(GatewayConfig config) {
        return this.getBaseGatewayUrl(config) + "/knoxsso/knoxauth/logout.jsp?originalUrl=" + this.getBaseGatewayUrl(config) + "/homepage/home";
    }

    private String getGlobalLogoutPageUrl(GatewayConfig config) {
        return config.getGlobalLogoutPageUrl();
    }
}

