/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.qq;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oauth.profile.creator.OAuth20ProfileCreator;
import org.pac4j.oauth.profile.qq.QQProfile;
import org.pac4j.oauth.profile.qq.QQProfileDefinition;

public class QQProfileCreator
extends OAuth20ProfileCreator<QQProfile> {
    public QQProfileCreator(OAuth20Configuration configuration, IndirectClient client) {
        super(configuration, client);
    }

    @Override
    public Optional<UserProfile> retrieveUserProfileFromToken(WebContext context, OAuth2AccessToken accessToken) {
        QQProfileDefinition profileDefinition = (QQProfileDefinition)((OAuth20Configuration)this.configuration).getProfileDefinition();
        String openidUrl = profileDefinition.getOpenidUrl(accessToken, (OAuth20Configuration)this.configuration);
        OAuth20Service service = ((OAuth20Configuration)this.configuration).buildService(context, this.client);
        String body = this.sendRequestForData(service, accessToken, openidUrl, Verb.GET);
        String openid = profileDefinition.extractOpenid(body);
        String profileUrl = profileDefinition.getProfileUrl(accessToken, (OAuth20Configuration)this.configuration);
        profileUrl = CommonHelper.addParameter((String)profileUrl, (String)"openid", (String)openid);
        body = this.sendRequestForData(service, accessToken, profileUrl = CommonHelper.addParameter((String)profileUrl, (String)"oauth_consumer_key", (String)((OAuth20Configuration)this.configuration).getKey()), Verb.GET);
        if (body == null) {
            throw new HttpCommunicationException("Not data found for accessToken: " + accessToken);
        }
        QQProfile profile = profileDefinition.extractUserProfile(body);
        this.addAccessTokenToProfile(profile, accessToken);
        profile.setId(openid);
        return Optional.of(profile);
    }
}

