/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.security.interfaces.ECPrivateKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.store.GuavaStore;
import org.pac4j.core.store.Store;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;

public class AppleOidcConfiguration
extends OidcConfiguration {
    private static final Duration MAX_TIMEOUT = Duration.ofSeconds(15777000L);
    private ECPrivateKey privateKey;
    private String privateKeyID;
    private String teamID;
    private Store<String, String> store;
    private Duration timeout = MAX_TIMEOUT;

    @Override
    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"privateKeyID", (String)this.privateKeyID);
        CommonHelper.assertNotNull((String)"privateKey", (Object)this.privateKey);
        CommonHelper.assertNotBlank((String)"teamID", (String)this.teamID);
        if (this.timeout.compareTo(MAX_TIMEOUT) > 0) {
            throw new IllegalArgumentException(String.format("timeout must not be greater then %d seconds", MAX_TIMEOUT.toSeconds()));
        }
        if (this.store == null) {
            this.store = new GuavaStore(1000, (int)this.timeout.toSeconds(), TimeUnit.SECONDS);
        }
        OIDCProviderMetadata providerMetadata = new OIDCProviderMetadata(new Issuer("https://appleid.apple.com"), Collections.singletonList(SubjectType.PAIRWISE), URI.create("https://appleid.apple.com/auth/keys"));
        providerMetadata.setAuthorizationEndpointURI(URI.create("https://appleid.apple.com/auth/authorize"));
        providerMetadata.setTokenEndpointURI(URI.create("https://appleid.apple.com/auth/token"));
        providerMetadata.setIDTokenJWSAlgs(Collections.singletonList(JWSAlgorithm.RS256));
        this.setProviderMetadata(providerMetadata);
        this.setClientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST);
        super.internalInit();
    }

    @Override
    public String getSecret() {
        Optional cache;
        if (this.store != null && (cache = this.store.get((Object)this.getClientId())).isPresent()) {
            return (String)cache.get();
        }
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().issuer(this.getTeamID()).audience("https://appleid.apple.com").subject(this.getClientId()).issueTime(Date.from(Instant.now())).expirationTime(Date.from(Instant.now().plusSeconds(this.timeout.toSeconds()))).build();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.ES256).keyID(this.privateKeyID).build(), claimsSet);
        try {
            ECDSASigner signer = new ECDSASigner(this.privateKey);
            signedJWT.sign((JWSSigner)signer);
        }
        catch (JOSEException e) {
            throw new TechnicalException((Throwable)e);
        }
        String secret = signedJWT.serialize();
        if (this.store != null) {
            this.store.set((Object)this.getClientId(), (Object)secret);
        }
        return secret;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(ECPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyID() {
        return this.privateKeyID;
    }

    public void setPrivateKeyID(String privateKeyID) {
        this.privateKeyID = privateKeyID;
    }

    public String getTeamID() {
        return this.teamID;
    }

    public void setTeamID(String teamID) {
        this.teamID = teamID;
    }

    public Store<String, String> getStore() {
        return this.store;
    }

    public void setStore(Store<String, String> store) {
        this.store = store;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

