/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.admin;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryFactory;

@Path(value="/api/v1")
public class ServiceDiscoveryResource {
    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="servicediscoveries")
    public ServiceDiscoveryWrapper getServiceDiscoveries() {
        ServiceDiscoveryWrapper serviceDiscoveryWrapper = new ServiceDiscoveryWrapper();
        serviceDiscoveryWrapper.setKnoxServiceDiscoveries(ServiceDiscoveryFactory.getAllServiceDiscoveries());
        return serviceDiscoveryWrapper;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ServiceDiscoveryWrapper {
        @XmlElement(name="knoxServiceDiscovery")
        @XmlElementWrapper(name="knoxServiceDiscoveries")
        private Set<KnoxServiceDiscovery> knoxServiceDiscoveries = new HashSet<KnoxServiceDiscovery>();

        public Set<KnoxServiceDiscovery> getKnoxServiceDiscoveries() {
            return this.knoxServiceDiscoveries;
        }

        public void setKnoxServiceDiscoveries(Set<KnoxServiceDiscovery> knoxServiceDiscoveries) {
            this.knoxServiceDiscoveries = knoxServiceDiscoveries;
        }

        void setKnoxServiceDiscoveries(Collection<ServiceDiscovery> serviceDiscoveries) {
            serviceDiscoveries.forEach(serviceDiscovery -> this.knoxServiceDiscoveries.add(new KnoxServiceDiscovery(serviceDiscovery.getType(), serviceDiscovery.getClass().getCanonicalName())));
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class KnoxServiceDiscovery {
        @XmlElement
        private final String type;
        @XmlElement
        private final String implementation;

        public KnoxServiceDiscovery() {
            this(null, null);
        }

        public KnoxServiceDiscovery(String type, String implementation) {
            this.type = type;
            this.implementation = implementation;
        }

        public String getType() {
            return this.type;
        }

        public String getImplementation() {
            return this.implementation;
        }
    }
}

