/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.httpclient.TLSSocketFactoryBuilder;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public final class HttpClientSupport {
    private static final String CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS = "java-support.DynamicContextHandlers";

    private HttpClientSupport() {
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildStrictTLSSocketFactory() {
        return new TLSSocketFactoryBuilder().setHostnameVerifier((X509HostnameVerifier)new StrictHostnameVerifier()).build();
    }

    @Nonnull
    public static LayeredConnectionSocketFactory buildNoTrustTLSSocketFactory() {
        return new TLSSocketFactoryBuilder().setTrustManagers(Collections.singletonList(HttpClientSupport.buildNoTrustX509TrustManager())).setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
    }

    @Deprecated
    @Nonnull
    public static SSLConnectionSocketFactory buildStrictSSLConnectionSocketFactory() {
        DeprecationSupport.warnOnce(DeprecationSupport.ObjectType.METHOD, "net.shibboleth.utilities.java.support.httpclient.HttpClientSupport.buildStrictSSLConnectionSocketFactory", null, "buildStrictTLSSocketFactory");
        return new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
    }

    @Deprecated
    @Nonnull
    public static SSLConnectionSocketFactory buildNoTrustSSLConnectionSocketFactory() {
        DeprecationSupport.warnOnce(DeprecationSupport.ObjectType.METHOD, "net.shibboleth.utilities.java.support.httpclient.HttpClientSupport.buildNoTrustSSLConnectionSocketFactory", null, "buildNoTrustTLSSocketFactory");
        X509TrustManager noTrustManager = HttpClientSupport.buildNoTrustX509TrustManager();
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{noTrustManager}, null);
            return new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("TLS SSLContext type is required to be supported by the JVM but is not", e);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException("Somehow the trust everything trust manager didn't trust everything", e);
        }
    }

    @Nonnull
    public static X509TrustManager buildNoTrustX509TrustManager() {
        return new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
    }

    @Nonnull
    public static List<HttpClientContextHandler> getDynamicContextHandlerList(@Nonnull HttpClientContext context) {
        Constraint.isNotNull(context, "HttpClientContext was null");
        ArrayList handlers = (ArrayList)context.getAttribute(CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS, List.class);
        if (handlers == null) {
            handlers = new ArrayList();
            context.setAttribute(CONTEXT_KEY_DYNAMIC_CONTEXT_HANDLERS, handlers);
        }
        return handlers;
    }

    public static void addDynamicContextHandlerFirst(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler) {
        Constraint.isNotNull(handler, "HttpClientContextHandler was null");
        HttpClientSupport.getDynamicContextHandlerList(context).add(0, handler);
    }

    public static void addDynamicContextHandlerLast(@Nonnull HttpClientContext context, @Nonnull HttpClientContextHandler handler) {
        Constraint.isNotNull(handler, "HttpClientContextHandler was null");
        HttpClientSupport.getDynamicContextHandlerList(context).add(handler);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static String toString(@Nonnull HttpEntity entity, @Nullable Charset defaultCharset, int maxLength) throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public static String toString(@Nonnull HttpEntity entity, @Nullable String defaultCharset, int maxLength) throws IOException, ParseException {
        return HttpClientSupport.toString(entity, defaultCharset != null ? Charset.forName(defaultCharset) : null, maxLength);
    }

    @Nullable
    public static String toString(@Nonnull HttpEntity entity, int maxLength) throws IOException, ParseException {
        return HttpClientSupport.toString(entity, (Charset)null, maxLength);
    }
}

