/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.monitor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClient;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitor;

class DefaultRemoteConfigurationMonitor
implements RemoteConfigurationMonitor {
    private static final String NODE_KNOX = "/knox";
    private static final String NODE_KNOX_CONFIG = "/knox/config";
    private static final String NODE_KNOX_PROVIDERS = "/knox/config/shared-providers";
    private static final String NODE_KNOX_DESCRIPTORS = "/knox/config/descriptors";
    private static GatewayMessages log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final RemoteConfigurationRegistryClient.EntryACL AUTHENTICATED_USERS_ALL = new RemoteConfigurationRegistryClient.EntryACL(){

        public String getId() {
            return "";
        }

        public String getType() {
            return "auth";
        }

        public Object getPermissions() {
            return 31;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return true;
        }
    };
    private static final RemoteConfigurationRegistryClient.EntryACL WORLD_ANYONE_READ = new RemoteConfigurationRegistryClient.EntryACL(){

        public String getId() {
            return "anyone";
        }

        public String getType() {
            return "world";
        }

        public Object getPermissions() {
            return 1;
        }

        public boolean canRead() {
            return true;
        }

        public boolean canWrite() {
            return false;
        }
    };
    private RemoteConfigurationRegistryClient client;
    private File providersDir;
    private File descriptorsDir;
    private final List<RemoteConfigurationRegistryClient.EntryACL> replacementACL = new ArrayList<RemoteConfigurationRegistryClient.EntryACL>();

    DefaultRemoteConfigurationMonitor(GatewayConfig config, RemoteConfigurationRegistryClientService registryClientService) {
        this.providersDir = new File(config.getGatewayProvidersConfigDir());
        this.descriptorsDir = new File(config.getGatewayDescriptorsDir());
        if (registryClientService != null) {
            String clientName = config.getRemoteConfigurationMonitorClientName();
            if (clientName != null) {
                this.client = registryClientService.get(clientName);
                if (this.client == null) {
                    log.unresolvedClientConfigurationForRemoteMonitoring(clientName);
                } else if (config.allowUnauthenticatedRemoteRegistryReadAccess()) {
                    this.replacementACL.add(WORLD_ANYONE_READ);
                }
            } else {
                log.missingClientConfigurationForRemoteMonitoring();
                throw new IllegalStateException("Missing required configuration.");
            }
        }
        this.replacementACL.add(AUTHENTICATED_USERS_ALL);
    }

    public RemoteConfigurationRegistryClient getClient() {
        return this.client;
    }

    public void start() throws Exception {
        if (this.client == null) {
            throw new IllegalStateException("Failed to acquire a remote configuration registry client.");
        }
        String monitorSource = this.client.getAddress();
        log.startingRemoteConfigurationMonitor(monitorSource);
        this.ensureEntries();
        List providerConfigs = this.client.listChildEntries(NODE_KNOX_PROVIDERS);
        if (providerConfigs == null) {
            throw new IllegalStateException("Unable to access remote path: /knox/config/shared-providers");
        }
        for (String providerConfig : providerConfigs) {
            File localFile = new File(this.providersDir, providerConfig);
            byte[] remoteContent = this.client.getEntryData("/knox/config/shared-providers/" + providerConfig).getBytes(StandardCharsets.UTF_8);
            if (localFile.exists() && Arrays.equals(remoteContent, FileUtils.readFileToByteArray((File)localFile))) continue;
            FileUtils.writeByteArrayToFile((File)localFile, (byte[])remoteContent);
            log.downloadedRemoteConfigFile(this.providersDir.getName(), providerConfig);
        }
        List descriptors = this.client.listChildEntries(NODE_KNOX_DESCRIPTORS);
        if (descriptors == null) {
            throw new IllegalStateException("Unable to access remote path: /knox/config/descriptors");
        }
        this.client.addChildEntryListener(NODE_KNOX_PROVIDERS, (RemoteConfigurationRegistryClient.ChildEntryListener)new ConfigDirChildEntryListener(this.providersDir));
        this.client.addChildEntryListener(NODE_KNOX_DESCRIPTORS, (RemoteConfigurationRegistryClient.ChildEntryListener)new ConfigDirChildEntryListener(this.descriptorsDir));
        log.monitoringRemoteConfigurationSource(monitorSource);
    }

    public void stop() throws Exception {
        this.client.removeEntryListener(NODE_KNOX_PROVIDERS);
        this.client.removeEntryListener(NODE_KNOX_DESCRIPTORS);
    }

    private void ensureEntries() {
        this.ensureEntry(NODE_KNOX);
        this.ensureEntry(NODE_KNOX_CONFIG);
        this.ensureEntry(NODE_KNOX_PROVIDERS);
        this.ensureEntry(NODE_KNOX_DESCRIPTORS);
    }

    private void ensureEntry(String name) {
        if (!this.client.entryExists(name)) {
            this.client.createEntry(name);
        } else {
            List entryACLs = this.client.getACL(name);
            for (RemoteConfigurationRegistryClient.EntryACL entryACL : entryACLs) {
                if (!entryACL.getType().equals("world") || !entryACL.getId().equals("anyone")) continue;
                log.suspectWritableRemoteConfigurationEntry(name);
                if (!this.client.isAuthenticationConfigured()) continue;
                log.correctingSuspectWritableRemoteConfigurationEntry(name);
                this.client.setACL(name, this.replacementACL);
            }
        }
    }

    private static class ConfigEntryListener
    implements RemoteConfigurationRegistryClient.EntryListener {
        private File localDir;

        ConfigEntryListener(File localDir) {
            this.localDir = localDir;
        }

        public void entryChanged(RemoteConfigurationRegistryClient client, String path, byte[] data) {
            File localFile = new File(this.localDir, path.substring(path.lastIndexOf(47)));
            if (data != null) {
                try {
                    if (!localFile.exists() || !Arrays.equals(FileUtils.readFileToByteArray((File)localFile), data)) {
                        FileUtils.writeByteArrayToFile((File)localFile, (byte[])data);
                        log.downloadedRemoteConfigFile(this.localDir.getName(), localFile.getName());
                    }
                }
                catch (IOException e) {
                    log.errorDownloadingRemoteConfiguration(path, e);
                }
            } else {
                FileUtils.deleteQuietly((File)localFile);
                log.deletedRemoteConfigFile(this.localDir.getName(), localFile.getName());
            }
        }
    }

    private static class ConfigDirChildEntryListener
    implements RemoteConfigurationRegistryClient.ChildEntryListener {
        File localDir;

        ConfigDirChildEntryListener(File localDir) {
            this.localDir = localDir;
        }

        public void childEvent(RemoteConfigurationRegistryClient client, RemoteConfigurationRegistryClient.ChildEntryListener.Type type, String path) {
            File localFile = new File(this.localDir, path.substring(path.lastIndexOf(47) + 1));
            switch (type) {
                case REMOVED: {
                    FileUtils.deleteQuietly((File)localFile);
                    log.deletedRemoteConfigFile(this.localDir.getName(), localFile.getName());
                    try {
                        client.removeEntryListener(path);
                    }
                    catch (Exception e) {
                        log.errorRemovingRemoteConfigurationListenerForPath(path, e);
                    }
                    break;
                }
                case ADDED: {
                    try {
                        client.addEntryListener(path, (RemoteConfigurationRegistryClient.EntryListener)new ConfigEntryListener(this.localDir));
                        break;
                    }
                    catch (Exception e) {
                        log.errorAddingRemoteConfigurationListenerForPath(path, e);
                    }
                }
            }
        }
    }
}

