/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.securequery;

import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.knox.gateway.securequery.SecureQueryEncodeDescriptor;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class SecureQueryEncodeProcessor
implements UrlRewriteStepProcessor<SecureQueryEncodeDescriptor> {
    private static final String ENCODED_PARAMETER_NAME = "_";

    public String getType() {
        return "encode-query";
    }

    public void initialize(UrlRewriteEnvironment environment, SecureQueryEncodeDescriptor descriptor) throws Exception {
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        String str;
        Template url = context.getCurrentUrl();
        String path = str = url.toString();
        String query = null;
        int index = str.indexOf(63);
        if (index >= 0) {
            path = str.substring(0, index);
            if (index < str.length()) {
                query = str.substring(index + 1);
            }
        }
        if (query != null) {
            query = Base64.encodeBase64String((byte[])query.getBytes(StandardCharsets.UTF_8));
            query = SecureQueryEncodeProcessor.removeTrailingEquals(query);
            url = Parser.parseLiteral((String)(path + "?" + ENCODED_PARAMETER_NAME + "=" + query));
            context.setCurrentUrl(url);
        }
        return UrlRewriteStepStatus.SUCCESS;
    }

    public void destroy() {
    }

    private static String removeTrailingEquals(String s) {
        int i;
        for (i = s.length() - 1; i > 0 && s.charAt(i) == '='; --i) {
        }
        return s.substring(0, i + 1);
    }
}

