/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.global;

import java.util.HashSet;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.annotations.FetchMode;
import org.hibernate.metamodel.binding.FetchProfile;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.jboss.jandex.AnnotationInstance;

public class FetchProfileBinder {
    private FetchProfileBinder() {
    }

    public static void bind(AnnotationBindingContext bindingContext) {
        List annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.FETCH_PROFILE);
        for (AnnotationInstance fetchProfile : annotations) {
            FetchProfileBinder.bind(bindingContext.getMetadataImplementor(), fetchProfile);
        }
        annotations = bindingContext.getIndex().getAnnotations(HibernateDotNames.FETCH_PROFILES);
        for (AnnotationInstance fetchProfiles : annotations) {
            AnnotationInstance[] fetchProfileAnnotations;
            for (AnnotationInstance fetchProfile : fetchProfileAnnotations = JandexHelper.getValue(fetchProfiles, "value", AnnotationInstance[].class)) {
                FetchProfileBinder.bind(bindingContext.getMetadataImplementor(), fetchProfile);
            }
        }
    }

    private static void bind(MetadataImplementor metadata, AnnotationInstance fetchProfile) {
        AnnotationInstance[] overrideAnnotations;
        String name = JandexHelper.getValue(fetchProfile, "name", String.class);
        HashSet<FetchProfile.Fetch> fetches = new HashSet<FetchProfile.Fetch>();
        for (AnnotationInstance override : overrideAnnotations = JandexHelper.getValue(fetchProfile, "fetchOverrides", AnnotationInstance[].class)) {
            FetchMode fetchMode = JandexHelper.getEnumValue(override, "mode", FetchMode.class);
            if (!fetchMode.equals((Object)FetchMode.JOIN)) {
                throw new MappingException("Only FetchMode.JOIN is currently supported");
            }
            String entityName = JandexHelper.getValue(override, "entity", String.class);
            String associationName = JandexHelper.getValue(override, "association", String.class);
            fetches.add(new FetchProfile.Fetch(entityName, associationName, fetchMode.toString().toLowerCase()));
        }
        metadata.addFetchProfile(new FetchProfile(name, fetches));
    }
}

