/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.maven;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.WriteResource;
import aQute.bnd.stream.MapStream;
import aQute.bnd.unmodifiable.Lists;
import aQute.lib.io.IO;
import aQute.lib.tag.Tag;
import aQute.libg.glob.Glob;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PomResource
extends WriteResource {
    private static final String VERSION = "version";
    private static final String ARTIFACTID = "artifactid";
    private static final String GROUPID = "groupid";
    private static final String WHERE = "where";
    private static final List<String> local = Lists.of("version", "artifactid", "groupid", "where", "artifactId", "groupId");
    final Manifest manifest;
    private Map<String, String> scm;
    final Processor processor;
    static final Pattern NAME_URL = Pattern.compile("(.*)(https?://.*)", 2);
    private final String where;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String name;

    public PomResource(Manifest manifest) {
        this(new Processor(), manifest);
    }

    public PomResource(Map<String, String> map, Manifest manifest) {
        this(PomResource.asProcessor(map), manifest);
    }

    private static Processor asProcessor(Map<String, String> map) {
        Processor scoped = new Processor();
        scoped.addProperties(map);
        return scoped;
    }

    public PomResource(Processor scoped, Manifest manifest) {
        this(scoped, manifest, null, null, null);
    }

    public PomResource(Processor scoped, Manifest manifest, String groupId, String artifactId, String version) {
        String name;
        scoped.setForceLocal(local);
        this.processor = scoped;
        this.manifest = manifest;
        Domain domain = Domain.domain(manifest);
        String bsn = null;
        Map.Entry<String, Attrs> bundleSymbolicName = domain.getBundleSymbolicName();
        if (bundleSymbolicName != null) {
            bsn = bundleSymbolicName.getKey();
        }
        if (bsn != null) {
            String g = this.augmentManifest(domain, bsn);
            if (groupId == null) {
                groupId = g;
            }
        }
        String where = this.processor.getProperty(WHERE);
        if (groupId == null) {
            groupId = this.processor.getProperty(GROUPID);
        }
        if (groupId == null) {
            groupId = this.processor.getProperty("-groupid");
        }
        if (groupId == null) {
            groupId = this.processor.getProperty("groupId");
        }
        if (artifactId == null) {
            artifactId = this.processor.getProperty(ARTIFACTID);
        }
        if (artifactId == null) {
            artifactId = this.processor.getProperty("artifactId");
        }
        if (groupId != null) {
            if (artifactId == null) {
                if (bsn == null) {
                    throw new RuntimeException("Cannot create POM unless bsn is set");
                }
                artifactId = bsn;
            }
            if (where == null) {
                where = String.format("META-INF/maven/%s/%s/pom.xml", groupId, artifactId);
            }
        } else {
            if (bsn == null) {
                throw new RuntimeException("Cannot create POM unless bsn is set");
            }
            int n = bsn.lastIndexOf(46);
            if (n <= 0) {
                throw new RuntimeException("\"groupid\" not set andBundle-SymbolicName does not contain a '.' to separate into a groupid and artifactid.");
            }
            if (artifactId == null) {
                artifactId = bsn.substring(n + 1);
            }
            groupId = bsn.substring(0, n);
            if (where == null) {
                where = "pom.xml";
            }
        }
        if ((name = domain.get("Bundle-Name")) == null) {
            name = groupId + ":" + artifactId;
        }
        if (version == null) {
            version = this.processor.getProperty(VERSION);
        }
        if (version == null) {
            version = domain.getBundleVersion();
        }
        if (version == null) {
            version = "0";
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.name = name;
        this.where = where;
    }

    public String augmentManifest(Domain domain, String bsn) {
        String groupid = null;
        Parameters augments = new Parameters(this.processor.mergeProperties("-pomaugment"), this.processor);
        for (Map.Entry<String, Attrs> augment : augments.entrySet()) {
            Glob g = new Glob(augment.getKey());
            if (!g.matcher(bsn).matches()) continue;
            Attrs attrs = augment.getValue();
            for (Map.Entry<String, String> attr : attrs.entrySet()) {
                String key = attr.getKey();
                boolean mandatory = false;
                if (key.startsWith("+")) {
                    key = key.substring(1);
                    mandatory = true;
                }
                if (key.length() > 0 && Character.isUpperCase(key.charAt(0))) {
                    if (!mandatory && domain.get(key) != null) continue;
                    domain.set(key, attr.getValue());
                    continue;
                }
                if (!GROUPID.equals(key)) continue;
                groupid = attr.getValue();
            }
        }
        return groupid;
    }

    public String getWhere() {
        return this.where;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public void write(OutputStream out) throws IOException {
        String validate;
        String description = this.manifest.getMainAttributes().getValue("Bundle-Description");
        String docUrl = this.manifest.getMainAttributes().getValue("Bundle-DocURL");
        String bundleVendor = this.manifest.getMainAttributes().getValue("Bundle-Vendor");
        String bundleLicense = this.manifest.getMainAttributes().getValue("Bundle-License");
        Tag project = new Tag("project", new Object[0]);
        project.addAttribute("xmlns", "http://maven.apache.org/POM/4.0.0");
        project.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        project.addAttribute("xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd");
        project.addContent(new Tag("modelVersion", new Object[0]).addContent("4.0.0"));
        project.addContent(new Tag("groupId", new Object[0]).addContent(this.getGroupId()));
        project.addContent(new Tag("artifactId", new Object[0]).addContent(this.getArtifactId()));
        project.addContent(new Tag(VERSION, new Object[0]).addContent(this.getVersion()));
        if (description == null) {
            description = this.name;
        }
        new Tag(project, "description", new Object[0]).addContent(description);
        new Tag(project, "name", new Object[0]).addContent(this.name);
        if (docUrl != null) {
            new Tag(project, "url", new Object[0]).addContent(docUrl);
        }
        if (this.scm != null) {
            Tag scm = new Tag(project, "scm", new Object[0]);
            for (Map.Entry<String, String> e : this.scm.entrySet()) {
                new Tag(scm, e.getKey(), new Object[0]).addContent(e.getValue());
            }
        }
        if (bundleVendor != null) {
            Matcher m = NAME_URL.matcher(bundleVendor);
            String namePart = bundleVendor;
            Object urlPart = null;
            if (m.matches()) {
                namePart = m.group(1);
                urlPart = m.group(2);
            }
            Tag organization = new Tag(project, "organization", new Object[0]);
            new Tag(organization, "name", new Object[0]).addContent(namePart.trim());
            if (urlPart != null) {
                new Tag(organization, "url", new Object[0]).addContent(((String)urlPart).trim());
            }
        }
        Tag ls = null;
        Parameters licenses = new Parameters(bundleLicense, this.processor);
        for (Map.Entry<String, Attrs> license : licenses.entrySet()) {
            String identifier = license.getKey();
            if (identifier == null || (identifier = identifier.trim()).equals("<<EXTERNAL>>")) continue;
            if (ls == null) {
                ls = new Tag(project, "licenses", new Object[0]);
            }
            Iterator<String> l = new Tag(ls, "license", new Object[0]);
            Map attrs2 = license.getValue();
            this.tagFromMap((Tag)((Object)l), attrs2, "name", "name", identifier);
            this.tagFromMap((Tag)((Object)l), attrs2, "link", "url", identifier);
            this.tagFromMap((Tag)((Object)l), attrs2, "distribution", "distribution", "repo");
            this.tagFromMap((Tag)((Object)l), attrs2, "description", "comments", null);
        }
        String scm = this.manifest.getMainAttributes().getValue("Bundle-SCM");
        if (scm != null && scm.length() > 0) {
            Attrs pscm = OSGiHeader.parseProperties(scm);
            Tag tscm = new Tag(project, "scm", new Object[0]);
            for (String s : pscm.keySet()) {
                new Tag(tscm, s, (Object)pscm.get(s));
            }
        } else {
            this.processor.warning("POM will not validate on Central due to missing Bundle-SCM header", new Object[0]);
        }
        Parameters developers = new Parameters(this.manifest.getMainAttributes().getValue("Bundle-Developers"), this.processor);
        if (developers.size() > 0) {
            Tag tdevelopers = new Tag(project, "developers", new Object[0]);
            for (String id : developers.keySet()) {
                Tag tdeveloper = new Tag(tdevelopers, "developer", new Object[0]);
                new Tag(tdeveloper, "id", (Object)id);
                Attrs i = new Attrs(developers.get(id));
                if (!i.containsKey("email")) {
                    i.put("email", id);
                }
                i.remove("id");
                for (String s : i.keySet()) {
                    if (s.equals("roles")) {
                        String[] roles;
                        Tag troles = new Tag(tdeveloper, "roles", new Object[0]);
                        for (String role : roles = i.get(s).trim().split("\\s*,\\s*")) {
                            new Tag(troles, "role", (Object)role);
                        }
                        continue;
                    }
                    new Tag(tdeveloper, s, (Object)i.get(s));
                }
            }
        } else {
            this.processor.warning("POM will not validate on Central due to missing Bundle-Developers header", new Object[0]);
        }
        Parameters dependencies = this.processor.getMergedParameters("-maven-dependencies");
        if (!dependencies.isEmpty()) {
            Tag tdependencies = new Tag("dependencies", new Object[0]);
            dependencies.stream().mapKey(Processor::removeDuplicateMarker).collect(MapStream.toMap((oldValue, value) -> value, LinkedHashMap::new)).values().forEach(attrs -> {
                if (!attrs.isEmpty()) {
                    tdependencies.addContent(new Tag("dependency", new Object[0]).addContent((Map<String, ?>)attrs));
                }
            });
            if (!tdependencies.getContents().isEmpty()) {
                project.addContent(tdependencies);
            }
        }
        if ((validate = project.validate()) != null) {
            throw new IllegalArgumentException(validate);
        }
        PrintWriter pw = IO.writer(out);
        pw.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        project.print(0, pw);
        pw.flush();
    }

    private Tag tagFromMap(Tag parent, Map<String, String> attrs, String key, String tag, String defaultValue) {
        String value = attrs.get(key);
        if (value == null) {
            value = attrs.get(tag);
        }
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            return parent;
        }
        new Tag(parent, tag, new Object[0]).addContent(value.trim());
        return parent;
    }

    public void setProperties(Map<String, String> scm) {
        this.scm = scm;
    }

    public String validate() {
        return null;
    }
}

