/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicHeader;

@Header
@Schema(type="integer", format="int64")
public class BasicLongHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Long value;
    private final Supplier<Long> supplier;

    public static BasicLongHeader of(String name, Long value) {
        return value == null ? null : new BasicLongHeader(name, value);
    }

    public static BasicLongHeader of(String name, String value) {
        return value == null ? null : new BasicLongHeader(name, value);
    }

    public static BasicLongHeader of(String name, Supplier<Long> value) {
        return value == null ? null : new BasicLongHeader(name, value);
    }

    public BasicLongHeader(String name, Long value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicLongHeader(String name, String value) {
        super(name, value);
        this.value = BasicLongHeader.parse(value);
        this.supplier = null;
    }

    public BasicLongHeader(String name, Supplier<Long> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    public Optional<Long> asLong() {
        return Utils.opt(this.value());
    }

    public FluentLongAssertion<BasicLongHeader> assertLong() {
        return new FluentLongAssertion<BasicLongHeader>(this.value(), this);
    }

    @Override
    public String getValue() {
        return Utils.s(this.value());
    }

    public Long orElse(Long other) {
        Long x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public Long toLong() {
        return this.value();
    }

    private static Long parse(String value) {
        try {
            return value == null ? null : Long.valueOf(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw ThrowableUtils.rex(e, "Value ''{0}'' could not be parsed as a long.", value);
        }
    }

    private Long value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

