/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.IntervalSize;
import org.locationtech.jts.index.quadtree.Node;
import org.locationtech.jts.index.quadtree.NodeBase;
import org.locationtech.jts.util.Assert;

public class Root
extends NodeBase {
    private static final Coordinate origin = new Coordinate(0.0, 0.0);

    public void insert(Envelope itemEnv, Object item) {
        int index = Root.getSubnodeIndex(itemEnv, Root.origin.x, Root.origin.y);
        if (index == -1) {
            this.add(item);
            return;
        }
        Node node = this.subnode[index];
        if (node == null || !node.getEnvelope().contains(itemEnv)) {
            Node largerNode;
            this.subnode[index] = largerNode = Node.createExpanded(node, itemEnv);
        }
        this.insertContained(this.subnode[index], itemEnv, item);
    }

    private void insertContained(Node tree, Envelope itemEnv, Object item) {
        Assert.isTrue(tree.getEnvelope().contains(itemEnv));
        boolean isZeroX = IntervalSize.isZeroWidth(itemEnv.getMinX(), itemEnv.getMaxX());
        boolean isZeroY = IntervalSize.isZeroWidth(itemEnv.getMinY(), itemEnv.getMaxY());
        NodeBase node = isZeroX || isZeroY ? tree.find(itemEnv) : tree.getNode(itemEnv);
        node.add(item);
    }

    @Override
    protected boolean isSearchMatch(Envelope searchEnv) {
        return true;
    }
}

