/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypes {
    static final Logger LOG = LoggerFactory.getLogger(MimeTypes.class);
    private static final Set<Locale> KNOWN_LOCALES = Set.copyOf(Arrays.asList(Locale.getAvailableLocales()));
    public static final String ISO_8859_1 = StandardCharsets.ISO_8859_1.name().toLowerCase();
    public static final String UTF8 = StandardCharsets.UTF_8.name().toLowerCase();
    public static final String UTF16 = StandardCharsets.UTF_16.name().toLowerCase();
    private static final Index<String> CHARSETS = new Index.Builder().caseSensitive(false).with("utf-8", UTF8).with("utf8", UTF8).with("utf-16", UTF16).with("utf16", UTF16).with("iso-8859-1", ISO_8859_1).with("iso_8859_1", ISO_8859_1).build();
    private static final Index<String> WILDS = new Index.Builder().caseSensitive(false).with("text/", "text/*").with("image/", "image/*").with("application/xml", "application/*").with("multipart/", "multipart/*").build();
    public static final Index<Type> CACHE = new Index.Builder().caseSensitive(false).withAll(() -> {
        HashMap<String, Type> result = new HashMap<String, Type>();
        for (Type type : Type.values()) {
            String key1 = type.toString();
            result.put(key1, type);
            if (key1.indexOf(";charset=") <= 0) continue;
            String key2 = StringUtil.replace(key1, ";charset=", "; charset=");
            result.put(key2, type);
        }
        return result;
    }).build();
    protected final Map<String, String> _mimeMap = new HashMap<String, String>();
    protected final Map<String, Charset> _inferredEncodings = new HashMap<String, Charset>();
    protected final Map<String, Charset> _assumedEncodings = new HashMap<String, Charset>();
    protected final Set<String> _assumedNoEncodings = new HashSet<String>();
    public static final MimeTypes DEFAULTS = new MimeTypes(null){
        {
            InputStream stream;
            for (Type type : Type.values()) {
                if (!type.isCharsetAssumed()) continue;
                this._assumedEncodings.put(type.asString(), type.getCharset());
            }
            String resourceName = "mime.properties";
            try {
                stream = MimeTypes.class.getResourceAsStream(resourceName);
                try {
                    this.loadMimeProperties(stream, resourceName);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e2) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to load mime-type resource: {}", (Object)resourceName, (Object)e2);
                }
                LOG.warn("Unable to load mime-type resource: {} - {}", (Object)resourceName, (Object)e2.toString());
            }
            resourceName = "encoding.properties";
            try {
                stream = MimeTypes.class.getResourceAsStream(resourceName);
                try {
                    this.loadEncodings(stream, resourceName);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e3) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Unable to load encoding resource: {}", (Object)resourceName, (Object)e3);
                }
                LOG.warn("Unable to load encoding resource: {} - {}", (Object)resourceName, (Object)e3.toString());
            }
        }
    };

    public static String getBase(String value) {
        int index = value.indexOf(59);
        return index == -1 ? value : value.substring(0, index);
    }

    public static Type getBaseType(String contentType) {
        if (StringUtil.isEmpty(contentType)) {
            return null;
        }
        Type type = CACHE.getBest(contentType);
        if (type == null && (type = CACHE.get(MimeTypes.getBase(contentType))) == null) {
            return null;
        }
        return type.getBaseType();
    }

    public static boolean isKnownLocale(Locale locale) {
        return KNOWN_LOCALES.contains(locale);
    }

    public static String normalizeCharset(String charsetName) {
        String n = CHARSETS.get(charsetName);
        return n == null ? charsetName : n;
    }

    public static String normalizeCharset(String charsetName, int offset, int length) {
        String n = CHARSETS.get(charsetName, offset, length);
        return n == null ? charsetName.substring(offset, offset + length) : n;
    }

    public static Charset getKnownCharset(String charsetName) throws UnsupportedEncodingException {
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(charsetName)) {
            return StandardCharsets.UTF_8;
        }
        charsetName = MimeTypes.normalizeCharset(charsetName);
        if (StandardCharsets.UTF_8.name().equalsIgnoreCase(charsetName)) {
            return StandardCharsets.UTF_8;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e2) {
            throw new UnsupportedEncodingException(e2.getMessage());
        }
    }

    private static String nameOf(Charset charset) {
        return charset == null ? null : charset.name();
    }

    public MimeTypes() {
        this(DEFAULTS);
    }

    public MimeTypes(MimeTypes defaults) {
        if (defaults != null) {
            this._mimeMap.putAll(defaults.getMimeMap());
            this._assumedEncodings.putAll(defaults._assumedEncodings);
            this._inferredEncodings.putAll(defaults._inferredEncodings);
            this._assumedNoEncodings.addAll(defaults._assumedNoEncodings);
        }
    }

    protected void loadMimeProperties(InputStream stream, String resourceName) throws IOException {
        if (stream == null) {
            throw new IOException("Missing mime-type resource: " + resourceName);
        }
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            Properties props = new Properties();
            props.load(reader);
            props.stringPropertyNames().stream().filter(Objects::nonNull).forEach(x -> {
                if (x.contains(".")) {
                    LOG.warn("ignoring invalid extension {} from mime.properties {}", x, (Object)resourceName);
                } else {
                    this._mimeMap.put(StringUtil.asciiToLowerCase(x), MimeTypes.normalizeMimeType(props.getProperty((String)x)));
                }
            });
        }
    }

    protected void loadEncodings(InputStream stream, String resourceName) throws IOException {
        if (stream == null) {
            throw new IOException("Missing encoding resource: " + resourceName);
        }
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            Properties props = new Properties();
            props.load(reader);
            props.stringPropertyNames().stream().filter(Objects::nonNull).forEach(type -> {
                String charset = props.getProperty((String)type);
                if ("-".equals(charset)) {
                    this._assumedNoEncodings.add((String)type);
                } else if (charset.startsWith("-")) {
                    this._assumedEncodings.put((String)type, Charset.forName(charset.substring(1)));
                } else {
                    this._inferredEncodings.put((String)type, Charset.forName(props.getProperty((String)type)));
                }
            });
        }
    }

    public Charset getCharset(HttpField field) throws IllegalCharsetNameException, UnsupportedCharsetException {
        if (field instanceof ContentTypeField) {
            ContentTypeField contentTypeField = (ContentTypeField)field;
            return contentTypeField.getMimeType().getCharset();
        }
        return this.getCharset(field.getValue());
    }

    public Charset getCharset(String mimeType) throws IllegalCharsetNameException, UnsupportedCharsetException {
        if (mimeType == null) {
            return null;
        }
        Type mime = CACHE.get(mimeType);
        if (mime != null && mime.getCharset() != null) {
            return mime.getCharset();
        }
        String charsetName = MimeTypes.getCharsetFromContentType(mimeType);
        if (charsetName != null) {
            return Charset.forName(charsetName);
        }
        Charset charset = this.getAssumedCharset(mimeType);
        if (charset != null) {
            return charset;
        }
        charset = this.getInferredCharset(mimeType);
        return charset;
    }

    public String getMimeByExtension(String filename) {
        String ext = FileID.getExtension(filename);
        return this.getMimeForExtension(Objects.requireNonNullElse(ext, "*"));
    }

    public String getMimeForExtension(String extension) {
        return this._mimeMap.get(extension);
    }

    public Charset getInferredCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        Charset charset = this._inferredEncodings.get(contentType);
        if (charset == null) {
            charset = this._inferredEncodings.get(this.toWild(contentType));
        }
        return charset;
    }

    public Charset getAssumedCharset(String contentType) {
        if (contentType == null) {
            return null;
        }
        Charset charset = this._assumedEncodings.get(contentType);
        if (charset == null) {
            charset = this._assumedEncodings.get(this.toWild(contentType));
        }
        return charset;
    }

    public boolean isCharsetAssumed(String contentType) {
        Charset charset = this._assumedEncodings.get(contentType);
        if (charset == null) {
            if (this._assumedNoEncodings.contains(contentType)) {
                return true;
            }
            String wild = this.toWild(contentType);
            charset = this._assumedEncodings.get(wild);
            return charset != null || this._assumedNoEncodings.contains(wild);
        }
        return false;
    }

    public String getInferredCharsetName(String contentType) {
        return MimeTypes.nameOf(this.getInferredCharset(contentType));
    }

    public String getAssumedCharsetName(String contentType) {
        if (contentType == null) {
            return null;
        }
        Charset charset = this.getAssumedCharset(contentType);
        if (charset == null) {
            return this.isCharsetAssumed(contentType) ? "" : null;
        }
        return charset.name();
    }

    public Map<String, String> getMimeMap() {
        return Collections.unmodifiableMap(this._mimeMap);
    }

    private static String normalizeMimeType(String type) {
        Type t = CACHE.get(type);
        if (t != null) {
            return t.asString();
        }
        return StringUtil.asciiToLowerCase(type);
    }

    public static Type getMimeTypeFromContentType(HttpField field) {
        if (field == null) {
            return null;
        }
        assert (field.getHeader() == HttpHeader.CONTENT_TYPE);
        if (field instanceof ContentTypeField) {
            ContentTypeField contentTypeField = (ContentTypeField)field;
            return contentTypeField.getMimeType();
        }
        String contentType = field.getValue();
        int semicolon = contentType.indexOf(59);
        if (semicolon >= 0) {
            contentType = contentType.substring(0, semicolon).trim();
        }
        return CACHE.get(contentType);
    }

    public static String getMimeTypeAsStringFromContentType(HttpField field) {
        if (field == null) {
            return null;
        }
        assert (field.getHeader() == HttpHeader.CONTENT_TYPE);
        if (field instanceof ContentTypeField) {
            ContentTypeField contentTypeField = (ContentTypeField)field;
            return contentTypeField.getMimeType().asString();
        }
        return MimeTypes.getBase(field.getValue());
    }

    public static Charset getCharsetFromContentType(HttpField field) {
        if (field == null) {
            return null;
        }
        assert (field.getHeader() == HttpHeader.CONTENT_TYPE);
        if (field instanceof ContentTypeField) {
            ContentTypeField contentTypeField = (ContentTypeField)field;
            return contentTypeField._type.getCharset();
        }
        String charset = MimeTypes.getCharsetFromContentType(field.getValue());
        if (charset == null) {
            return null;
        }
        return Charset.forName(charset);
    }

    public static String getCharsetFromContentType(String value) {
        int i;
        if (value == null) {
            return null;
        }
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        block13: for (i = 0; i < end; ++i) {
            char b = value.charAt(i);
            if (quote && state != 10) {
                if ('\"' != b) continue;
                quote = false;
                continue;
            }
            if (';' == b && state <= 8) {
                state = 1;
                continue;
            }
            switch (state) {
                case 0: {
                    if ('\"' != b) continue block13;
                    quote = true;
                    continue block13;
                }
                case 1: {
                    if ('c' == b) {
                        state = 2;
                        continue block13;
                    }
                    if (' ' == b) continue block13;
                    state = 0;
                    continue block13;
                }
                case 2: {
                    if ('h' == b) {
                        state = 3;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 3: {
                    if ('a' == b) {
                        state = 4;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 4: {
                    if ('r' == b) {
                        state = 5;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 5: {
                    if ('s' == b) {
                        state = 6;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 6: {
                    if ('e' == b) {
                        state = 7;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 7: {
                    if ('t' == b) {
                        state = 8;
                        continue block13;
                    }
                    state = 0;
                    continue block13;
                }
                case 8: {
                    if ('=' == b) {
                        state = 9;
                        continue block13;
                    }
                    if (' ' == b) continue block13;
                    state = 0;
                    continue block13;
                }
                case 9: {
                    if (' ' == b) continue block13;
                    if ('\"' == b) {
                        quote = true;
                        start = i + 1;
                        state = 10;
                        continue block13;
                    }
                    start = i;
                    state = 10;
                    continue block13;
                }
                case 10: {
                    if ((quote || ';' != b && ' ' != b) && (!quote || '\"' != b)) continue block13;
                    return MimeTypes.normalizeCharset(value, start, i - start);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (state == 10) {
            return MimeTypes.normalizeCharset(value, start, i - start);
        }
        return null;
    }

    public static String getContentTypeWithoutCharset(String value) {
        int end = value.length();
        int state = 0;
        int start = 0;
        boolean quote = false;
        StringBuilder builder = null;
        block19: for (int i = 0; i < end; ++i) {
            char b = value.charAt(i);
            if ('\"' == b) {
                quote = !quote;
                switch (state) {
                    case 11: {
                        builder.append(b);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 9: {
                        builder = new StringBuilder();
                        builder.append(value, 0, start + 1);
                        state = 10;
                        break;
                    }
                    default: {
                        start = i;
                        state = 0;
                        break;
                    }
                }
                continue;
            }
            if (quote) {
                if (builder == null || state == 10) continue;
                builder.append(b);
                continue;
            }
            switch (state) {
                case 0: {
                    if (';' == b) {
                        state = 1;
                        continue block19;
                    }
                    if (' ' == b) continue block19;
                    start = i;
                    continue block19;
                }
                case 1: {
                    if ('c' == b) {
                        state = 2;
                        continue block19;
                    }
                    if (' ' == b) continue block19;
                    state = 0;
                    continue block19;
                }
                case 2: {
                    if ('h' == b) {
                        state = 3;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 3: {
                    if ('a' == b) {
                        state = 4;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 4: {
                    if ('r' == b) {
                        state = 5;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 5: {
                    if ('s' == b) {
                        state = 6;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 6: {
                    if ('e' == b) {
                        state = 7;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 7: {
                    if ('t' == b) {
                        state = 8;
                        continue block19;
                    }
                    state = 0;
                    continue block19;
                }
                case 8: {
                    if ('=' == b) {
                        state = 9;
                        continue block19;
                    }
                    if (' ' == b) continue block19;
                    state = 0;
                    continue block19;
                }
                case 9: {
                    if (' ' == b) continue block19;
                    builder = new StringBuilder();
                    builder.append(value, 0, start + 1);
                    state = 10;
                    continue block19;
                }
                case 10: {
                    if (';' != b) continue block19;
                    builder.append(b);
                    state = 11;
                    continue block19;
                }
                case 11: {
                    if (' ' == b) continue block19;
                    builder.append(b);
                    continue block19;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (builder == null) {
            return value;
        }
        return builder.toString();
    }

    private String toWild(String contentType) {
        String wild = WILDS.getBest(contentType);
        if (wild != null) {
            return wild;
        }
        int slash = contentType.indexOf(47);
        if (slash > 0) {
            return contentType.substring(0, slash) + "/*";
        }
        return "*/*";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type {
        FORM_ENCODED("application/x-www-form-urlencoded"),
        FORM_ENCODED_UTF_8("application/x-www-form-urlencoded;charset=utf-8", FORM_ENCODED),
        FORM_ENCODED_8859_1("application/x-www-form-urlencoded;charset=iso-8859-1", FORM_ENCODED),
        MESSAGE_HTTP("message/http"),
        MULTIPART_BYTERANGES("multipart/byteranges"),
        MULTIPART_FORM_DATA("multipart/form-data"),
        TEXT_HTML("text/html"){

            @Override
            public HttpField getContentTypeField(Charset charset) {
                if (Objects.equals(charset, StandardCharsets.UTF_8)) {
                    return TEXT_HTML_UTF_8.getContentTypeField();
                }
                if (Objects.equals(charset, StandardCharsets.ISO_8859_1)) {
                    return TEXT_HTML_8859_1.getContentTypeField();
                }
                return super.getContentTypeField(charset);
            }
        }
        ,
        TEXT_HTML_8859_1("text/html;charset=iso-8859-1", TEXT_HTML),
        TEXT_HTML_UTF_8("text/html;charset=utf-8", TEXT_HTML),
        TEXT_PLAIN("text/plain"){

            @Override
            public HttpField getContentTypeField(Charset charset) {
                if (Objects.equals(charset, StandardCharsets.UTF_8)) {
                    return TEXT_PLAIN_UTF_8.getContentTypeField();
                }
                if (Objects.equals(charset, StandardCharsets.ISO_8859_1)) {
                    return TEXT_PLAIN_8859_1.getContentTypeField();
                }
                return super.getContentTypeField(charset);
            }
        }
        ,
        TEXT_PLAIN_8859_1("text/plain;charset=iso-8859-1", TEXT_PLAIN),
        TEXT_PLAIN_UTF_8("text/plain;charset=utf-8", TEXT_PLAIN),
        TEXT_XML("text/xml"){

            @Override
            public HttpField getContentTypeField(Charset charset) {
                if (Objects.equals(charset, StandardCharsets.UTF_8)) {
                    return TEXT_XML_UTF_8.getContentTypeField();
                }
                if (Objects.equals(charset, StandardCharsets.ISO_8859_1)) {
                    return TEXT_XML_8859_1.getContentTypeField();
                }
                return super.getContentTypeField(charset);
            }
        }
        ,
        TEXT_XML_8859_1("text/xml;charset=iso-8859-1", TEXT_XML),
        TEXT_XML_UTF_8("text/xml;charset=utf-8", TEXT_XML),
        TEXT_JSON("text/json", StandardCharsets.UTF_8),
        TEXT_JSON_8859_1("text/json;charset=iso-8859-1", TEXT_JSON),
        TEXT_JSON_UTF_8("text/json;charset=utf-8", TEXT_JSON),
        APPLICATION_JSON("application/json", StandardCharsets.UTF_8),
        APPLICATION_JSON_8859_1("application/json;charset=iso-8859-1", APPLICATION_JSON),
        APPLICATION_JSON_UTF_8("application/json;charset=utf-8", APPLICATION_JSON);

        private final String _string;
        private final Type _base;
        private final Charset _charset;
        private final String _charsetString;
        private final boolean _assumedCharset;
        private final ContentTypeField _field;

        private Type(String name) {
            this._string = name;
            this._base = this;
            this._charset = null;
            this._charsetString = null;
            this._assumedCharset = false;
            this._field = new ContentTypeField(this);
        }

        private Type(String name, Type base) {
            this._string = name;
            this._base = Objects.requireNonNull(base);
            int i = name.indexOf(";charset=");
            this._charset = Charset.forName(name.substring(i + 9));
            this._charsetString = this._charset.toString().toLowerCase(Locale.ENGLISH);
            this._assumedCharset = false;
            this._field = new ContentTypeField(this);
        }

        private Type(String name, Charset cs) {
            this._string = name;
            this._base = this;
            this._charset = cs;
            this._charsetString = this._charset == null ? null : this._charset.toString().toLowerCase(Locale.ENGLISH);
            this._assumedCharset = true;
            this._field = new ContentTypeField(this);
        }

        public Charset getCharset() {
            return this._charset;
        }

        public String getCharsetString() {
            return this._charsetString;
        }

        public boolean is(String type) {
            return this._string.equalsIgnoreCase(type);
        }

        public String asString() {
            return this._string;
        }

        public String toString() {
            return this._string;
        }

        public boolean isCharsetAssumed() {
            return this._assumedCharset;
        }

        public HttpField getContentTypeField() {
            return this._field;
        }

        public HttpField getContentTypeField(Charset charset) {
            if (Objects.equals(this._charset, charset)) {
                return this._field;
            }
            return new HttpField(HttpHeader.CONTENT_TYPE, MimeTypes.getContentTypeWithoutCharset(this._string) + ";charset=" + charset.name());
        }

        public Type getBaseType() {
            return this._base;
        }
    }

    static class ContentTypeField
    extends PreEncodedHttpField {
        private final Type _type;

        public ContentTypeField(Type type) {
            this(type, type.toString());
        }

        public ContentTypeField(Type type, String value) {
            super(HttpHeader.CONTENT_TYPE, value);
            this._type = type;
        }

        public Type getMimeType() {
            return this._type;
        }
    }

    public static class Mutable
    extends MimeTypes {
        boolean isDefault;

        public Mutable() {
            this(DEFAULTS);
        }

        public Mutable(MimeTypes defaults) {
            super(defaults);
            this.isDefault = defaults == DEFAULTS;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void clear() {
            this._mimeMap.clear();
            this._assumedEncodings.clear();
            this._assumedNoEncodings.clear();
            this._inferredEncodings.clear();
        }

        public String addMimeMapping(String extension, String type) {
            if (extension.contains(".")) {
                throw new IllegalArgumentException("extensions cannot contain '.'");
            }
            this.isDefault = false;
            if (type == null) {
                return (String)this._mimeMap.remove(StringUtil.asciiToLowerCase(extension));
            }
            return this._mimeMap.put(StringUtil.asciiToLowerCase(extension), MimeTypes.normalizeMimeType(type));
        }

        public String addInferred(String mimeType, String encoding) {
            this.isDefault = false;
            if (encoding == null) {
                return MimeTypes.nameOf((Charset)this._inferredEncodings.remove(MimeTypes.normalizeMimeType(mimeType)));
            }
            return MimeTypes.nameOf(this._inferredEncodings.put(MimeTypes.normalizeMimeType(mimeType), Charset.forName(encoding)));
        }

        public String addAssumed(String mimeType, String encoding) {
            this.isDefault = false;
            if (encoding == null) {
                this._assumedNoEncodings.remove(mimeType);
                return MimeTypes.nameOf((Charset)this._assumedEncodings.remove(mimeType));
            }
            if (encoding.isEmpty()) {
                this._assumedNoEncodings.add(mimeType);
                return MimeTypes.nameOf((Charset)this._assumedEncodings.remove(mimeType));
            }
            this._assumedNoEncodings.remove(mimeType);
            return MimeTypes.nameOf(this._assumedEncodings.put(mimeType, Charset.forName(encoding)));
        }

        public void setMimeTypes(Resource mimeProperties) throws UncheckedIOException {
            this._mimeMap.clear();
            this.addMimeTypes(mimeProperties);
        }

        public void addMimeTypes(Resource mimeProperties) throws UncheckedIOException {
            this.isDefault = false;
            try {
                this.loadMimeProperties(mimeProperties.newInputStream(), mimeProperties.toString());
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        public void setEncodings(Resource encodingProperties) throws UncheckedIOException {
            this._assumedNoEncodings.clear();
            this._assumedEncodings.clear();
            this._inferredEncodings.clear();
            this.addEncodings(encodingProperties);
        }

        public void addEncodings(Resource encodingProperties) throws UncheckedIOException {
            this.isDefault = false;
            try {
                this.loadEncodings(encodingProperties.newInputStream(), encodingProperties.toString());
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        public void setFrom(MimeTypes other) {
            this.clear();
            this._mimeMap.putAll(other.getMimeMap());
            this._assumedEncodings.putAll(other._assumedEncodings);
            this._inferredEncodings.putAll(other._inferredEncodings);
            this._assumedNoEncodings.addAll(other._assumedNoEncodings);
        }

        public void mergeFrom(MimeTypes other) {
            this.mergeMap(this._mimeMap, other._mimeMap, Mutable.DEFAULTS._mimeMap);
            this.mergeMap(this._assumedEncodings, other._assumedEncodings, Mutable.DEFAULTS._assumedEncodings);
            this.mergeMap(this._inferredEncodings, other._inferredEncodings, Mutable.DEFAULTS._inferredEncodings);
            this._assumedEncodings.clear();
            this._assumedEncodings.putAll(other._assumedEncodings);
            this._inferredEncodings.clear();
            this._inferredEncodings.putAll(other._inferredEncodings);
            this._assumedNoEncodings.clear();
            this._assumedNoEncodings.addAll(other._assumedNoEncodings);
            for (String encoding : other._assumedNoEncodings) {
                if (Mutable.DEFAULTS._assumedNoEncodings.contains(encoding)) continue;
                this._assumedNoEncodings.add(encoding);
            }
        }

        private <V> void mergeMap(Map<String, V> target, Map<String, V> other, Map<String, V> reference) {
            for (Map.Entry<String, V> entry : reference.entrySet()) {
                String key = entry.getKey();
                V value = entry.getValue();
                if (!Objects.equals(target.get(key), value)) continue;
                V otherValue = other.get(entry.getKey());
                if (otherValue == null) {
                    target.remove(key);
                    continue;
                }
                if (Objects.equals(value, otherValue)) continue;
                entry.setValue(otherValue);
            }
            for (Map.Entry<String, V> entry : other.entrySet()) {
                if (reference.containsKey(entry.getKey())) continue;
                target.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

