/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.IndexedResourceBundle;

public final class Locales
extends Static {
    private static final Map<Locale, Locale> POOL;
    private static final short LANGUAGE = 0;
    private static final short COUNTRY = Short.MIN_VALUE;
    private static final short[] ISO3;
    private static final short[] ISO2;
    public static final Locales ALL;
    public static final Locales SIS;

    private Locales() {
    }

    public Locale[] getAvailableLanguages() {
        if (this == ALL) {
            return Locales.getLanguages(Locale.getAvailableLocales());
        }
        return new Locale[]{Locale.ENGLISH, Locale.FRENCH};
    }

    public Locale[] getAvailableLocales() {
        if (this == ALL) {
            return Locale.getAvailableLocales();
        }
        Locale[] locales = this.getAvailableLanguages();
        String[] languages = new String[locales.length];
        for (int i = 0; i < languages.length; ++i) {
            languages[i] = locales[i].getLanguage();
        }
        int count = 0;
        block1: for (Locale locale : locales = Locale.getAvailableLocales()) {
            String code = locale.getLanguage();
            for (String language : languages) {
                if (!code.equals(language)) continue;
                locales[count++] = Locales.unique(locale);
                continue block1;
            }
        }
        locales = ArraysExt.resize(locales, count);
        return locales;
    }

    private static Locale[] getLanguages(Locale ... locales) {
        LinkedHashSet<String> codes = new LinkedHashSet<String>(Containers.hashMapCapacity(locales.length));
        for (Locale locale : locales) {
            codes.add(locale.getLanguage());
        }
        int i = 0;
        Locale[] languages = new Locale[codes.size()];
        for (String code : codes) {
            languages[i++] = Locales.unique(new Locale(code));
        }
        return languages;
    }

    public static Locale parse(String code) throws IllformedLocaleException {
        return Locales.parse(code, 0);
    }

    public static Locale parse(String code, int fromIndex) throws IllformedLocaleException {
        ArgumentChecks.ensureNonNull("code", code);
        ArgumentChecks.ensurePositive("fromIndex", fromIndex);
        int p1 = code.indexOf(95, fromIndex);
        int i = code.indexOf(45, fromIndex);
        if (i >= 0 && (p1 < 0 || i < p1)) {
            return Locales.unique(new Locale.Builder().setLanguageTag(code).build());
        }
        String country = "";
        String variant = "";
        if (p1 < 0 && (p1 = code.indexOf(59, fromIndex)) < 0) {
            p1 = code.length();
        } else {
            int s = p1 + 1;
            int p2 = code.indexOf(95, s);
            if (p2 < 0) {
                p2 = code.length();
            } else {
                variant = (String)CharSequences.trimWhitespaces(code, p2 + 1, code.length());
            }
            country = (String)CharSequences.trimWhitespaces(code, s, p2);
        }
        String language = (String)CharSequences.trimWhitespaces(code, fromIndex, p1);
        language = Locales.toISO2(language, (short)0);
        country = Locales.toISO2(country, (short)Short.MIN_VALUE);
        return Locales.unique(new Locale.Builder().setLanguage(language).setRegion(country).setVariant(variant).build());
    }

    private static String toISO2(String code, short type) {
        int alpha2;
        short alpha3 = Locales.toNumber(code, type);
        if (alpha3 != 0 && (alpha2 = Arrays.binarySearch(ISO3, alpha3)) >= 0) {
            int base = ((alpha2 = ISO2[alpha2]) & Short.MIN_VALUE) != 0 ? 64 : 96;
            alpha2 &= Short.MAX_VALUE;
            int i = 0;
            char[] c = new char[3];
            do {
                c[i++] = (char)((alpha2 & 0x1F) + base);
            } while ((alpha2 >>>= 5) != 0);
            return String.valueOf(c, 0, i);
        }
        return code;
    }

    private static short toNumber(String code, short n) {
        int length = code.length();
        if (length >= 1 && length <= 3) {
            int shift = 0;
            for (int i = 0; i < length; ++i) {
                int c = code.charAt(i);
                if (c < 65 || (c -= c >= 97 ? 96 : 64) > 26) {
                    return 0;
                }
                n = (short)(n | c << shift);
                shift += 5;
            }
            return n;
        }
        return 0;
    }

    public static Locale unique(Locale locale) {
        Locale candidate = POOL.get(locale);
        return candidate != null ? candidate : locale;
    }

    static {
        Locale[] locales = Locale.getAvailableLocales();
        POOL = new HashMap<Locale, Locale>(Containers.hashMapCapacity(locales.length));
        for (Locale lc : locales) {
            POOL.put(lc, lc);
        }
        try {
            for (Field field : Locale.class.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !Locale.class.isAssignableFrom(field.getType())) continue;
                Locale toAdd = (Locale)field.get(null);
                POOL.put(toAdd, toAdd);
            }
        }
        catch (IllegalAccessException exception) {
            Logging.unexpectedException(IndexedResourceBundle.LOGGER, Locales.class, "<clinit>", exception);
        }
        Short CONFLICT = 0;
        TreeMap<Short, Short> map = new TreeMap<Short, Short>();
        for (Locale locale : POOL.values()) {
            short type = 0;
            do {
                Short p;
                short alpha3;
                short alpha2;
                if ((alpha2 = Locales.toNumber(type == 0 ? locale.getLanguage() : locale.getCountry(), type)) == 0) continue;
                try {
                    alpha3 = Locales.toNumber(type == 0 ? locale.getISO3Language() : locale.getISO3Country(), type);
                }
                catch (MissingResourceException e2) {
                    continue;
                }
                if (alpha3 == 0 || alpha3 == alpha2 || (p = map.put(alpha3, alpha2)) == null || p == alpha2) continue;
                map.put(alpha3, CONFLICT);
            } while ((type = (short)(type ^ Short.MIN_VALUE)) != 0);
        }
        while (map.values().remove(CONFLICT)) {
        }
        ISO3 = new short[map.size()];
        ISO2 = new short[map.size()];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            Locales.ISO3[i] = (Short)entry.getKey();
            Locales.ISO2[i++] = (Short)entry.getValue();
        }
        ALL = new Locales();
        SIS = new Locales();
    }
}

