/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.internal.VerticalDatumTypes;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.util.LegacyNamespaces;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

@XmlType(name="VerticalDatumType")
@XmlRootElement(name="VerticalDatum")
public class DefaultVerticalDatum
extends AbstractDatum
implements VerticalDatum {
    private static final long serialVersionUID = 380347456670516572L;
    private VerticalDatumType type;

    public DefaultVerticalDatum(Map<String, ?> properties, VerticalDatumType type) {
        super(properties);
        this.type = type;
        ArgumentChecks.ensureNonNull("type", type);
    }

    protected DefaultVerticalDatum(VerticalDatum datum) {
        super(datum);
        this.type = datum.getVerticalDatumType();
    }

    public static DefaultVerticalDatum castOrCopy(VerticalDatum object) {
        return object == null || object instanceof DefaultVerticalDatum ? (DefaultVerticalDatum)object : new DefaultVerticalDatum(object);
    }

    public Class<? extends VerticalDatum> getInterface() {
        return VerticalDatum.class;
    }

    private VerticalDatumType type() {
        VerticalDatumType t = this.type;
        if (t == null) {
            ReferenceIdentifier name = super.getName();
            this.type = t = VerticalDatumTypes.guess(name != null ? name.getCode() : null, super.getAlias(), null);
        }
        return t;
    }

    @Override
    public VerticalDatumType getVerticalDatumType() {
        return this.type();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                return this.type().equals(((DefaultVerticalDatum)object).type());
            }
            case BY_CONTRACT: {
                return Objects.equals(this.getVerticalDatumType(), ((VerticalDatum)object).getVerticalDatumType());
            }
        }
        return true;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)this.type().hashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.append(VerticalDatumTypes.toLegacy(this.type()));
            return "Vert_Datum";
        }
        return formatter.shortOrLong("VDatum", "VerticalDatum");
    }

    private DefaultVerticalDatum() {
    }

    @XmlElement(name="verticalDatumType")
    private VerticalDatumType getTypeElement() {
        return Context.isGMLVersion(Context.current(), LegacyNamespaces.VERSION_3_2) ? null : this.getVerticalDatumType();
    }

    private void setTypeElement(VerticalDatumType t) {
        if (this.type == null) {
            this.type = t;
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultVerticalDatum.class, "setTypeElement", "verticalDatumType");
        }
    }
}

