/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash.format;

import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.crypto.hash.SimpleHashProvider;
import org.apache.shiro.crypto.hash.format.ModularCryptFormat;
import org.apache.shiro.crypto.hash.format.ParsableHashFormat;
import org.apache.shiro.lang.codec.Base64;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.StringUtils;

public class Shiro1CryptFormat
implements ModularCryptFormat,
ParsableHashFormat {
    public static final String ID = "shiro1";
    public static final String MCF_PREFIX = "$shiro1$";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String format(Hash hash) {
        if (hash == null) {
            return null;
        }
        String algorithmName = hash.getAlgorithmName();
        ByteSource salt = hash.getSalt();
        int iterations = hash.getIterations();
        StringBuilder sb = new StringBuilder(MCF_PREFIX).append(algorithmName).append("$").append(iterations).append("$");
        if (salt != null) {
            sb.append(salt.toBase64());
        }
        sb.append("$");
        sb.append(hash.toBase64());
        return sb.toString();
    }

    @Override
    public Hash parse(String formatted) {
        int iterations;
        ByteSource salt;
        if (formatted == null) {
            return null;
        }
        if (!formatted.startsWith(MCF_PREFIX)) {
            String msg = "The argument is not a valid 'shiro1' formatted hash.";
            throw new IllegalArgumentException(msg);
        }
        String suffix = formatted.substring(MCF_PREFIX.length());
        String[] parts = suffix.split("\\$");
        String algorithmName = parts[0];
        if (!new SimpleHashProvider().getImplementedAlgorithms().contains(algorithmName)) {
            throw new UnsupportedOperationException("Algorithm " + algorithmName + " is not supported in shiro1 format.");
        }
        int i = parts.length - 1;
        String digestBase64 = parts[i--];
        String saltBase64 = parts[i--];
        String iterationsString = parts[i--];
        byte[] digest = Base64.decode(digestBase64);
        if (StringUtils.hasLength(saltBase64)) {
            byte[] saltBytes = Base64.decode(saltBase64);
            salt = ByteSource.Util.bytes(saltBytes);
        } else {
            salt = ByteSource.Util.bytes(new byte[0]);
        }
        try {
            iterations = Integer.parseInt(iterationsString);
        }
        catch (NumberFormatException e2) {
            String msg = "Unable to parse formatted hash string: " + formatted;
            throw new IllegalArgumentException(msg, e2);
        }
        SimpleHash hash = new SimpleHash(algorithmName);
        hash.setBytes(digest);
        hash.setSalt(salt);
        hash.setIterations(iterations);
        return hash;
    }
}

