/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.leviathan;

import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;

public class log
extends FunctionBase {
    @Override
    public NodeValue exec(List<NodeValue> args) {
        if (args.size() < 1 || args.size() > 2) {
            throw new ExprEvalException("Invalid number of arguments");
        }
        NodeValue v = args.get(0);
        if (args.size() == 1) {
            return NodeValue.makeDouble(Math.log10(v.getDouble()));
        }
        NodeValue base = args.get(1);
        return NodeValue.makeDouble(Math.log10(v.getDouble()) / Math.log10(base.getDouble()));
    }

    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() < 1 || args.size() > 2) {
            throw new QueryBuildException("Function '" + Lib.className(this) + "' takes one/two argument(s)");
        }
    }
}

