/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.cmd.CmdException;

public class Args {
    public static String[] argsPrepare(String[] argv) {
        List<String> argsList = Arrays.asList(argv);
        List<String> indirects = argsList.stream().filter(s -> s.startsWith("@")).toList();
        if (indirects.isEmpty()) {
            return argv;
        }
        if (indirects.size() > 1) {
            throw new CmdException("Multiple arguments files");
        }
        if (argsList.size() > 1) {
            throw new CmdException("Arguments file must be the only item on the command line");
        }
        String indirect = indirects.get(0);
        String fn = indirect.substring(1);
        try {
            if (fn.isEmpty()) {
                throw new CmdException("Empty arguments file name");
            }
            Path path = Path.of(fn, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new CmdException("No such file: " + fn);
            }
            List<String> lines = Files.readAllLines(path);
            String[] args2 = Args.toArgsArray(lines);
            return args2;
        }
        catch (NoSuchFileException ex) {
            throw new CmdException("No such file: " + fn);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new CmdException("Failed to process args file: " + ex.getMessage());
        }
    }

    private static String[] toArgsArray(List<String> lines) {
        ArrayList<String> outcome = new ArrayList<String>();
        boolean positionalsStarted = false;
        for (String s : lines) {
            if ((s = s.strip()).startsWith("#") || s.isEmpty()) continue;
            if (positionalsStarted) {
                outcome.add(s);
                continue;
            }
            if (s.startsWith("@")) {
                throw new CmdException("Argument file may not contain an argument file reference");
            }
            if (!s.startsWith("-")) {
                positionalsStarted = true;
                outcome.add(s);
                continue;
            }
            int idx = s.indexOf(32);
            if (idx == -1) {
                outcome.add(s.stripTrailing());
                continue;
            }
            String a = s.substring(0, idx);
            String v = s.substring(idx + 1).strip();
            outcome.add(a);
            outcome.add(v);
        }
        return outcome.toArray(new String[outcome.size()]);
    }
}

