/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.Calendar;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.TextDirection;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.riot.tokens.TokenizerText;
import org.apache.jena.sparql.sse.SSE;

public class NodeFactoryExtra {
    private static final PrefixMap prefixMappingDefault = Prefixes.adapt(SSE.getPrefixMapRead());

    public static Node parseNode(String nodeString) {
        return NodeFactoryExtra.parseNode(nodeString, prefixMappingDefault);
    }

    public static Node parseNode(String nodeString, PrefixMap pmap) {
        String x;
        Tokenizer tokenizer = TokenizerText.create().fromString(nodeString).build();
        if (!tokenizer.hasNext()) {
            throw new RiotException("Empty RDF term");
        }
        Token token = tokenizer.next();
        Node node = token.asNode(pmap);
        if (node == null) {
            throw new RiotException("Bad RDF Term: " + nodeString);
        }
        if (tokenizer.hasNext()) {
            throw new RiotException("Trailing characters in string: " + nodeString);
        }
        if (node.isURI() && (x = node.getURI()).indexOf(32) >= 0) {
            throw new RiotException("Space(s) in  IRI: " + nodeString);
        }
        return node;
    }

    @Deprecated(forRemoval=true)
    public static Node createLiteralNode(String lex, String lang, String datatypeURI) {
        return NodeFactoryExtra.createLiteralNode(lex, lang, null, datatypeURI);
    }

    @Deprecated(forRemoval=true)
    public static Node createLiteralNode(String lex, String lang, String baseDir, String datatypeURI) {
        if (datatypeURI != null && datatypeURI.equals("")) {
            datatypeURI = null;
        }
        if (lang != null && lang.equals("")) {
            lang = null;
        }
        RDFDatatype dType = null;
        if (datatypeURI != null) {
            dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
        }
        TextDirection baseDirection = TextDirection.createOrNull((String)baseDir);
        Node n = NodeFactory.createLiteral((String)lex, (String)lang, (TextDirection)baseDirection, (RDFDatatype)dType);
        return n;
    }

    public static int nodeToInt(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDint.isValidLiteral(lit)) {
            return Integer.MIN_VALUE;
        }
        int i = ((Number)lit.getValue()).intValue();
        return i;
    }

    public static long nodeToLong(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDlong.isValidLiteral(lit)) {
            return Long.MIN_VALUE;
        }
        long i = ((Number)lit.getValue()).longValue();
        return i;
    }

    public static float nodeToFloat(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDfloat.isValidLiteral(lit)) {
            return Float.NaN;
        }
        float f = ((Number)lit.getValue()).floatValue();
        return f;
    }

    public static double nodeToDouble(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDdouble.isValidLiteral(lit)) {
            return Double.NaN;
        }
        double d = ((Number)lit.getValue()).doubleValue();
        return d;
    }

    public static Node intToNode(int integer) {
        return NodeFactory.createLiteralDT((String)Integer.toString(integer), (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static Node intToNode(long integer) {
        return NodeFactory.createLiteralDT((String)Long.toString(integer), (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static Node floatToNode(float value) {
        return NodeFactory.createLiteralDT((String)Float.toString(value), (RDFDatatype)XSDDatatype.XSDfloat);
    }

    public static Node doubleToNode(double value) {
        return NodeFactory.createLiteralDT((String)Double.toString(value), (RDFDatatype)XSDDatatype.XSDdouble);
    }

    public static Node dateTimeToNode(Calendar c) {
        String lex = DateTimeUtils.calendarToXSDDateTimeString((Calendar)c);
        return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static Node dateToNode(Calendar c) {
        String lex = DateTimeUtils.calendarToXSDDateString((Calendar)c);
        return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdate);
    }

    public static Node timeToNode(Calendar c) {
        String lex = DateTimeUtils.calendarToXSDTimeString((Calendar)c);
        return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDtime);
    }

    public static Node nowAsDateTime() {
        String lex = DateTimeUtils.nowAsXSDDateTimeString();
        return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static Node todayAsDate() {
        String lex = DateTimeUtils.todayAsXSDDateString();
        return NodeFactory.createLiteralDT((String)lex, (RDFDatatype)XSDDatatype.XSDdate);
    }
}

