/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.api.CompactionApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.serialization.QuadsToJsonld;
import com.apicatalog.rdf.api.RdfConsumerException;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFFormatVariant;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class JsonLD11Writer
implements WriterDatasetRIOT {
    private static Map<String, ?> configIndented = Map.of("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
    private static Map<String, ?> configFlat = Map.of();
    private final RDFFormat format;

    public JsonLD11Writer(RDFFormat format) {
        this.format = format;
    }

    @Override
    public void write(OutputStream outputStream, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(datasetGraph);
        this.write$(outputStream, null, datasetGraph);
    }

    @Override
    public void write(Writer out, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        Objects.requireNonNull(out);
        Objects.requireNonNull(datasetGraph);
        this.write$(null, out, datasetGraph);
    }

    @Override
    public Lang getLang() {
        return this.format.getLang();
    }

    private void write$(OutputStream output, Writer writer, DatasetGraph dsg) {
        try {
            JsonStructure writeThis;
            JsonArray array = JsonLD11Writer.datasetToJSON(dsg);
            RDFFormatVariant variant = this.format.getVariant();
            boolean indented = true;
            if (Lib.equals((Object)variant, (Object)RDFFormat.PRETTY)) {
                writeThis = this.writePretty(array, dsg);
            } else if (variant == null || Lib.equals((Object)variant, (Object)RDFFormat.PLAIN)) {
                writeThis = this.writePlain(array, dsg);
            } else if (Lib.equals((Object)variant, (Object)RDFFormat.FLAT)) {
                writeThis = this.writePlain(array, dsg);
                indented = false;
            } else {
                writeThis = this.writePretty(array, dsg);
            }
            if (writeThis == null) {
                FmtLog.error(this.getClass(), (String)"Nothing to write", (Object[])new Object[0]);
                return;
            }
            if (!(writeThis instanceof JsonObject)) {
                FmtLog.warn(this.getClass(), (String)"Output is not a JSON object (%s)", (Object[])new Object[]{writeThis.getClass().getSimpleName()});
            }
            this.writeJson(writeThis, output, writer, indented);
        }
        catch (Throwable ex) {
            throw new JenaException("Exception while writing JSON-LD 1.1", ex);
        }
    }

    private static JsonArray datasetToJSON(DatasetGraph dsg) throws JsonLdError {
        QuadsToJsonld consumer = JsonLd.fromRdf();
        consumer.mode(JsonLdVersion.V1_1);
        dsg.stream().forEach(quad -> {
            String s = JsonLD11Writer.resource(quad.getSubject());
            String p = JsonLD11Writer.resource(quad.getPredicate());
            String g = JsonLD11Writer.resourceGraphName(quad.getGraph());
            Node obj = quad.getObject();
            if (obj.isURI() || obj.isBlank()) {
                String o = JsonLD11Writer.resource(obj);
                try {
                    consumer.quad(s, p, o, null, null, null, g);
                }
                catch (RdfConsumerException e2) {
                    e2.printStackTrace();
                }
            } else if (obj.isLiteral()) {
                String lex = obj.getLiteralLexicalForm();
                String datatype = obj.getLiteralDatatypeURI();
                String lang = obj.getLiteralLanguage();
                if (lang.isEmpty()) {
                    lang = null;
                }
                String dir = null;
                if (obj.getLiteralBaseDirection() != null) {
                    dir = obj.getLiteralBaseDirection().toString();
                }
                try {
                    consumer.quad(s, p, lex, datatype, lang, dir, g);
                }
                catch (RdfConsumerException ex) {
                    throw new JenaException("Exception while translating to JSON-LD", (Throwable)ex);
                }
            } else {
                if (obj.isTripleTerm()) {
                    throw new JenaTitaniumException("Triple terms not supported for JSON-LD");
                }
                throw new JenaTitaniumException("Encountered unexpected term: " + String.valueOf(obj));
            }
        });
        JsonArray array = consumer.toJsonLd();
        return array;
    }

    private static String resourceGraphName(Node gn) {
        if (gn == null || Quad.isDefaultGraph(gn)) {
            return null;
        }
        return JsonLD11Writer.resource(gn);
    }

    private static String resource(Node term) {
        if (term.isBlank()) {
            return "_:" + term.getBlankNodeLabel();
        }
        if (term.isURI()) {
            return term.getURI();
        }
        throw new JenaTitaniumException("Not a URI or a blank node");
    }

    private Map<String, ?> config(boolean indented) {
        return indented ? configIndented : configFlat;
    }

    private JsonStructure writePlain(JsonArray array, DatasetGraph dsg) throws JsonLdError {
        JsonObject writeRdf = Json.createObjectBuilder().add("@graph", (JsonValue)array).build();
        return writeRdf;
    }

    private JsonStructure writePretty(JsonArray array, DatasetGraph dsg) throws JsonLdError {
        JsonLdOptions options = new JsonLdOptions();
        JsonObjectBuilder cxt = Json.createObjectBuilder();
        dsg.prefixes().forEach((k, v) -> {
            if (!k.isEmpty()) {
                cxt.add(k, v);
            }
        });
        String vocab = dsg.prefixes().get("");
        if (vocab != null) {
            cxt.add("@vocab", vocab);
        }
        JsonObject context2 = cxt.build();
        JsonObject writeRdf = Json.createObjectBuilder().add("@context", (JsonValue)context2).add("@graph", (JsonValue)array).build();
        JsonDocument contextDoc = JsonDocument.of((JsonStructure)context2);
        CompactionApi api = JsonLd.compact((Document)JsonDocument.of((JsonStructure)writeRdf), (Document)contextDoc);
        api.rdfStar();
        JsonObject x = api.get();
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJson(JsonStructure json, OutputStream output, Writer writer, boolean indented) throws IOException {
        JsonWriter jw = this.startWrite(output, writer, true);
        try {
            jw.write(json);
        }
        finally {
            this.finishWrite(output, writer, true);
        }
    }

    private JsonWriter startWrite(OutputStream output, Writer writer, boolean indented) {
        Map<String, ?> config = this.config(indented);
        JsonWriterFactory factory = Json.createWriterFactory(config);
        return output != null ? factory.createWriter(output) : factory.createWriter(writer);
    }

    private void finishWrite(OutputStream output, Writer writer, boolean indented) throws IOException {
        boolean outputNL = indented;
        if (output != null) {
            if (outputNL) {
                output.write(10);
            }
            output.flush();
        } else {
            if (outputNL) {
                writer.write("\n");
            }
            writer.flush();
        }
    }

    static class JenaTitaniumException
    extends JenaException {
        JenaTitaniumException(String msg) {
            super(msg);
        }
    }
}

