/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;

public final class WindowDefinitionNode
extends WindowNode {
    private boolean inlined;
    private OrderByList orderByList;

    WindowDefinitionNode(String string, OrderByList orderByList, ContextManager contextManager) throws StandardException {
        super(string != null ? string : "IN-LINE", contextManager);
        this.orderByList = orderByList;
        this.inlined = string == null;
        if (orderByList != null) {
            throw StandardException.newException("0A000.S", "WINDOW/ORDER BY");
        }
    }

    @Override
    public String toString() {
        return "name: " + this.getName() + "\ninlined: " + this.inlined + "\n()\n";
    }

    @Override
    public void printSubNodes(int n) {
    }

    WindowDefinitionNode findEquivalentWindow(WindowList windowList) {
        for (WindowDefinitionNode windowDefinitionNode : windowList) {
            if (!this.isEquivalent(windowDefinitionNode)) continue;
            return windowDefinitionNode;
        }
        return null;
    }

    private boolean isEquivalent(WindowDefinitionNode windowDefinitionNode) {
        return this.orderByList == null && windowDefinitionNode.getOrderByList() == null;
    }

    OrderByList getOrderByList() {
        return this.orderByList;
    }
}

