/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.mailets;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Collection;
import java.util.List;
import org.apache.james.jdkim.api.PublicKeyRecordRetriever;
import org.apache.james.jdkim.exceptions.PermFailException;
import org.apache.james.jdkim.exceptions.TempFailException;

public class MockPublicKeyRecordRetriever
implements PublicKeyRecordRetriever {
    private final ImmutableMultimap<String, String> records;

    public MockPublicKeyRecordRetriever(String aRecord, CharSequence selector, CharSequence token) {
        this.records = ImmutableMultimap.of((Object)this.makeKey(selector, token), (Object)aRecord);
    }

    public List<String> getRecords(CharSequence methodAndOptions, CharSequence selector, CharSequence token) throws TempFailException, PermFailException {
        if ("dns/txt".equals(methodAndOptions)) {
            String search = this.makeKey(selector, token);
            ImmutableCollection res = this.records.get((Object)search);
            if (res.size() <= 0) {
                throw new TempFailException("Timout or servfail");
            }
            return ImmutableList.copyOf((Collection)res);
        }
        throw new PermFailException("Unsupported method");
    }

    private String makeKey(CharSequence selector, CharSequence token) {
        return selector.toString() + "._domainkey." + token.toString();
    }
}

