/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonEnum;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.CharFilterDefinitionVariant;
import org.opensearch.client.opensearch._types.analysis.HtmlStripCharFilter;
import org.opensearch.client.opensearch._types.analysis.IcuNormalizationCharFilter;
import org.opensearch.client.opensearch._types.analysis.KuromojiIterationMarkCharFilter;
import org.opensearch.client.opensearch._types.analysis.MappingCharFilter;
import org.opensearch.client.opensearch._types.analysis.PatternReplaceCharFilter;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class CharFilterDefinition
implements TaggedUnion<Kind, CharFilterDefinitionVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final CharFilterDefinitionVariant _value;
    public static final JsonpDeserializer<CharFilterDefinition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharFilterDefinition::setupCharFilterDefinitionDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final CharFilterDefinitionVariant _get() {
        return this._value;
    }

    public CharFilterDefinition(CharFilterDefinitionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._charFilterDefinitionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private CharFilterDefinition(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static CharFilterDefinition of(Function<Builder, ObjectBuilder<CharFilterDefinition>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isHtmlStrip() {
        return this._kind == Kind.HtmlStrip;
    }

    public HtmlStripCharFilter htmlStrip() {
        return (HtmlStripCharFilter)TaggedUnionUtils.get(this, Kind.HtmlStrip);
    }

    public boolean isIcuNormalizer() {
        return this._kind == Kind.IcuNormalizer;
    }

    public IcuNormalizationCharFilter icuNormalizer() {
        return (IcuNormalizationCharFilter)TaggedUnionUtils.get(this, Kind.IcuNormalizer);
    }

    public boolean isKuromojiIterationMark() {
        return this._kind == Kind.KuromojiIterationMark;
    }

    public KuromojiIterationMarkCharFilter kuromojiIterationMark() {
        return (KuromojiIterationMarkCharFilter)TaggedUnionUtils.get(this, Kind.KuromojiIterationMark);
    }

    public boolean isMapping() {
        return this._kind == Kind.Mapping;
    }

    public MappingCharFilter mapping() {
        return (MappingCharFilter)TaggedUnionUtils.get(this, Kind.Mapping);
    }

    public boolean isPatternReplace() {
        return this._kind == Kind.PatternReplace;
    }

    public PatternReplaceCharFilter patternReplace() {
        return (PatternReplaceCharFilter)TaggedUnionUtils.get(this, Kind.PatternReplace);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    protected static void setupCharFilterDefinitionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::htmlStrip, HtmlStripCharFilter._DESERIALIZER, "html_strip");
        op.add(Builder::icuNormalizer, IcuNormalizationCharFilter._DESERIALIZER, "icu_normalizer");
        op.add(Builder::kuromojiIterationMark, KuromojiIterationMarkCharFilter._DESERIALIZER, "kuromoji_iteration_mark");
        op.add(Builder::mapping, MappingCharFilter._DESERIALIZER, "mapping");
        op.add(Builder::patternReplace, PatternReplaceCharFilter._DESERIALIZER, "pattern_replace");
        op.setTypeProperty("type", null);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CharFilterDefinition> {
        private Kind _kind;
        private CharFilterDefinitionVariant _value;

        public ObjectBuilder<CharFilterDefinition> htmlStrip(HtmlStripCharFilter v) {
            this._kind = Kind.HtmlStrip;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> htmlStrip(Function<HtmlStripCharFilter.Builder, ObjectBuilder<HtmlStripCharFilter>> fn) {
            return this.htmlStrip(fn.apply(new HtmlStripCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> icuNormalizer(IcuNormalizationCharFilter v) {
            this._kind = Kind.IcuNormalizer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> icuNormalizer(Function<IcuNormalizationCharFilter.Builder, ObjectBuilder<IcuNormalizationCharFilter>> fn) {
            return this.icuNormalizer(fn.apply(new IcuNormalizationCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> kuromojiIterationMark(KuromojiIterationMarkCharFilter v) {
            this._kind = Kind.KuromojiIterationMark;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> kuromojiIterationMark(Function<KuromojiIterationMarkCharFilter.Builder, ObjectBuilder<KuromojiIterationMarkCharFilter>> fn) {
            return this.kuromojiIterationMark(fn.apply(new KuromojiIterationMarkCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> mapping(MappingCharFilter v) {
            this._kind = Kind.Mapping;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> mapping(Function<MappingCharFilter.Builder, ObjectBuilder<MappingCharFilter>> fn) {
            return this.mapping(fn.apply(new MappingCharFilter.Builder()).build());
        }

        public ObjectBuilder<CharFilterDefinition> patternReplace(PatternReplaceCharFilter v) {
            this._kind = Kind.PatternReplace;
            this._value = v;
            return this;
        }

        public ObjectBuilder<CharFilterDefinition> patternReplace(Function<PatternReplaceCharFilter.Builder, ObjectBuilder<PatternReplaceCharFilter>> fn) {
            return this.patternReplace(fn.apply(new PatternReplaceCharFilter.Builder()).build());
        }

        @Override
        public CharFilterDefinition build() {
            this._checkSingleUse();
            return new CharFilterDefinition(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        HtmlStrip("html_strip"),
        IcuNormalizer("icu_normalizer"),
        KuromojiIterationMark("kuromoji_iteration_mark"),
        Mapping("mapping"),
        PatternReplace("pattern_replace");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

