/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.protocol;

import com.datastax.dse.driver.internal.core.graph.binary.buffer.DseNettyBufferFactory;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;

public class TinkerpopBufferPrimitiveCodec
implements PrimitiveCodec<Buffer> {
    private final DseNettyBufferFactory factory;

    public TinkerpopBufferPrimitiveCodec(DseNettyBufferFactory factory) {
        this.factory = factory;
    }

    public Buffer allocate(int size) {
        return this.factory.io(size, size);
    }

    public void release(Buffer toRelease) {
        toRelease.release();
    }

    public int sizeOf(Buffer toMeasure) {
        return toMeasure.readableBytes();
    }

    public Buffer concat(Buffer left, Buffer right) {
        boolean rightReadable;
        boolean leftReadable = left.readableBytes() > 0;
        boolean bl = rightReadable = right.readableBytes() > 0;
        if (!leftReadable && !rightReadable) {
            return this.factory.heap();
        }
        if (!leftReadable) {
            return right;
        }
        if (!rightReadable) {
            return left;
        }
        Buffer rv = this.factory.composite(left, right);
        rv.writerIndex(left.writerIndex() - left.readerIndex() + right.writerIndex() - right.readerIndex());
        return rv;
    }

    public void markReaderIndex(Buffer source) {
        throw new UnsupportedOperationException();
    }

    public void resetReaderIndex(Buffer source) {
        throw new UnsupportedOperationException();
    }

    public byte readByte(Buffer source) {
        return source.readByte();
    }

    public int readInt(Buffer source) {
        return source.readInt();
    }

    public int readInt(Buffer source, int offset) {
        throw new UnsupportedOperationException();
    }

    public InetAddress readInetAddr(Buffer source) {
        int length = this.readByte(source) & 0xFF;
        byte[] bytes = new byte[length];
        source.readBytes(bytes);
        return TinkerpopBufferPrimitiveCodec.newInetAddress(bytes);
    }

    public long readLong(Buffer source) {
        return source.readLong();
    }

    public int readUnsignedShort(Buffer source) {
        return source.readShort() & 0xFFFF;
    }

    public ByteBuffer readBytes(Buffer source) {
        int length = this.readInt(source);
        if (length < 0) {
            return null;
        }
        return source.nioBuffer(source.readerIndex(), length);
    }

    public byte[] readShortBytes(Buffer source) {
        try {
            int length = this.readUnsignedShort(source);
            byte[] bytes = new byte[length];
            source.readBytes(bytes);
            return bytes;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Not enough bytes to read a byte array preceded by its 2 bytes length");
        }
    }

    public String readString(Buffer source) {
        int length = this.readUnsignedShort(source);
        return TinkerpopBufferPrimitiveCodec.readString(source, length);
    }

    public String readLongString(Buffer source) {
        int length = this.readInt(source);
        return TinkerpopBufferPrimitiveCodec.readString(source, length);
    }

    public Buffer readRetainedSlice(Buffer source, int sliceLength) {
        throw new UnsupportedOperationException();
    }

    public void updateCrc(Buffer source, CRC32 crc) {
        throw new UnsupportedOperationException();
    }

    public void writeByte(byte b, Buffer dest) {
        dest.writeByte((int)b);
    }

    public void writeInt(int i, Buffer dest) {
        dest.writeInt(i);
    }

    public void writeInetAddr(InetAddress address, Buffer dest) {
        byte[] bytes = address.getAddress();
        this.writeByte((byte)bytes.length, dest);
        dest.writeBytes(bytes);
    }

    public void writeLong(long l, Buffer dest) {
        dest.writeLong(l);
    }

    public void writeUnsignedShort(int i, Buffer dest) {
        dest.writeShort(i);
    }

    public void writeString(String s, Buffer dest) {
        byte[] bytes = s.getBytes(Charsets.UTF_8);
        this.writeUnsignedShort(bytes.length, dest);
        dest.writeBytes(bytes);
    }

    public void writeLongString(String s, Buffer dest) {
        byte[] bytes = s.getBytes(Charsets.UTF_8);
        this.writeInt(bytes.length, dest);
        dest.writeBytes(bytes);
    }

    public void writeBytes(ByteBuffer bytes, Buffer dest) {
        if (bytes == null) {
            this.writeInt(-1, dest);
        } else {
            this.writeInt(bytes.remaining(), dest);
            dest.writeBytes(bytes.duplicate());
        }
    }

    public void writeBytes(byte[] bytes, Buffer dest) {
        if (bytes == null) {
            this.writeInt(-1, dest);
        } else {
            this.writeInt(bytes.length, dest);
            dest.writeBytes(bytes);
        }
    }

    public void writeShortBytes(byte[] bytes, Buffer dest) {
        this.writeUnsignedShort(bytes.length, dest);
        dest.writeBytes(bytes);
    }

    private static String readString(Buffer buff, int length) {
        try {
            int offset;
            byte[] bytes;
            ByteBuffer byteBuff = buff.nioBuffer();
            if (byteBuff.hasArray()) {
                bytes = byteBuff.array();
                offset = byteBuff.arrayOffset();
            } else {
                bytes = new byte[length];
                byteBuff.get(bytes, 0, length);
                offset = 0;
            }
            String str = new String(bytes, offset, length, Charsets.UTF_8);
            buff.readerIndex(buff.readerIndex() + length);
            return str;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Not enough bytes to read an UTF-8 serialized string of size " + length, e);
        }
    }

    private static InetAddress newInetAddress(byte[] bytes) {
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(String.format("Invalid address length: %d (%s)", bytes.length, Arrays.toString(bytes)));
        }
    }
}

