/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.probe.impl;

import java.io.IOException;
import javax.management.MalformedObjectNameException;
import org.apache.james.adapter.mailbox.QuotaManagementMBean;
import org.apache.james.cli.probe.impl.JmxConnection;
import org.apache.james.cli.probe.impl.JmxProbe;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.SerializableQuota;
import org.apache.james.mailbox.model.SerializableQuotaLimitValue;

public class JmxQuotaProbe
implements JmxProbe {
    private static final String QUOTAMANAGER_OBJECT_NAME = "org.apache.james:type=component,name=quotamanagerbean";
    private QuotaManagementMBean quotaManagement;

    @Override
    public JmxQuotaProbe connect(JmxConnection jmxc) throws IOException {
        try {
            this.quotaManagement = jmxc.retrieveBean(QuotaManagementMBean.class, QUOTAMANAGER_OBJECT_NAME);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        return this;
    }

    public String getQuotaRoot(String namespace, String user, String name) throws MailboxException {
        return this.quotaManagement.getQuotaRoot(namespace, user, name);
    }

    public SerializableQuota<QuotaCountLimit, QuotaCountUsage> getMessageCountQuota(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMessageCountQuota(quotaRoot);
    }

    public SerializableQuota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getStorageQuota(quotaRoot);
    }

    public SerializableQuotaLimitValue<QuotaCountLimit> getMaxMessageCount(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMaxMessageCount(quotaRoot);
    }

    public SerializableQuotaLimitValue<QuotaSizeLimit> getMaxStorage(String quotaRoot) throws MailboxException {
        return this.quotaManagement.getMaxStorage(quotaRoot);
    }

    public SerializableQuotaLimitValue<QuotaCountLimit> getGlobalMaxMessageCount() throws MailboxException {
        return this.quotaManagement.getGlobalMaxMessageCount();
    }

    public SerializableQuotaLimitValue<QuotaSizeLimit> getGlobalMaxStorage() throws MailboxException {
        return this.quotaManagement.getGlobalMaxStorage();
    }

    public void setMaxMessageCount(String quotaRoot, SerializableQuotaLimitValue<QuotaCountLimit> maxMessageCount) throws MailboxException {
        this.quotaManagement.setMaxMessageCount(quotaRoot, maxMessageCount);
    }

    public void setMaxStorage(String quotaRoot, SerializableQuotaLimitValue<QuotaSizeLimit> maxSize) throws MailboxException {
        this.quotaManagement.setMaxStorage(quotaRoot, maxSize);
    }

    public void setGlobalMaxMessageCount(SerializableQuotaLimitValue<QuotaCountLimit> maxGlobalMessageCount) throws MailboxException {
        this.quotaManagement.setGlobalMaxMessageCount(maxGlobalMessageCount);
    }

    public void setGlobalMaxStorage(SerializableQuotaLimitValue<QuotaSizeLimit> maxGlobalSize) throws MailboxException {
        this.quotaManagement.setGlobalMaxStorage(maxGlobalSize);
    }
}

