/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client.dn;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.protocol.client.dn.DataNodeAsyncRequestRPCHandler;
import org.apache.iotdb.db.protocol.client.dn.DnToDnRequestType;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTSStatusRPCHandler
extends DataNodeAsyncRequestRPCHandler<TSStatus> {
    private final boolean keepSilent;
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTSStatusRPCHandler.class);

    public AsyncTSStatusRPCHandler(DnToDnRequestType requestType, int requestId, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, TSStatus> responseMap, CountDownLatch countDownLatch, boolean keepSilent) {
        super(requestType, requestId, targetDataNode, dataNodeLocationMap, responseMap, countDownLatch);
        this.keepSilent = keepSilent;
    }

    public void onComplete(TSStatus response) {
        this.responseMap.put(this.requestId, response);
        if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            if (!this.keepSilent) {
                LOGGER.info("Successfully {} on DataNode: {}", this.requestType, (Object)this.formattedTargetLocation);
            }
        } else if (!this.keepSilent) {
            LOGGER.error("Failed to {} on DataNode: {}, response: {}", new Object[]{this.requestType, this.formattedTargetLocation, response});
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Failed to " + this.requestType + " on DataNode: " + this.formattedTargetLocation + ", exception: " + e.getMessage();
        if (!this.keepSilent) {
            LOGGER.error(errorMsg);
        }
        this.responseMap.put(this.requestId, new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
        this.countDownLatch.countDown();
    }
}

