/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.RegionScanNode;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DeviceRegionScanNode
extends RegionScanNode {
    private Map<PartialPath, DeviceContext> devicePathToContextMap;

    public DeviceRegionScanNode(PlanNodeId planNodeId, Map<PartialPath, DeviceContext> devicePathToContextMap, boolean outputCount, TRegionReplicaSet regionReplicaSet) {
        super(planNodeId);
        this.devicePathToContextMap = devicePathToContextMap;
        this.regionReplicaSet = regionReplicaSet;
        this.outputCount = outputCount;
    }

    public Map<PartialPath, DeviceContext> getDevicePathToContextMap() {
        return this.devicePathToContextMap;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("DeviceRegionScanNode has no children");
    }

    @Override
    public PlanNode clone() {
        return new DeviceRegionScanNode(this.getPlanNodeId(), this.getDevicePathToContextMap(), this.isOutputCount(), this.getRegionReplicaSet());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.outputCount ? ColumnHeaderConstant.countDevicesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList()) : ColumnHeaderConstant.showDevicesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeviceRegionScan(this, context);
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashMap<PartialPath, DeviceContext> devicePathToContextMap = new HashMap<PartialPath, DeviceContext>();
        for (int i = 0; i < size; ++i) {
            PartialPath path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer);
            devicePathToContextMap.put(path, DeviceContext.deserialize(buffer));
        }
        boolean outputCount = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new DeviceRegionScanNode(planNodeId, devicePathToContextMap, outputCount, null);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICE_REGION_SCAN.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.devicePathToContextMap.size(), (ByteBuffer)byteBuffer);
        for (Map.Entry<PartialPath, DeviceContext> entry : this.devicePathToContextMap.entrySet()) {
            entry.getKey().serialize(byteBuffer);
            entry.getValue().serializeAttributes(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.outputCount, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICE_REGION_SCAN.serialize(stream);
        ReadWriteIOUtils.write((int)this.devicePathToContextMap.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, DeviceContext> entry : this.devicePathToContextMap.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            entry.getValue().serializeAttributes(stream);
        }
        ReadWriteIOUtils.write((Boolean)this.outputCount, (OutputStream)stream);
    }

    public String toString() {
        return String.format("DeviceRegionScanNode-%s:[DataRegion: %s OutputCount: %s]", this.getPlanNodeId(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()), this.outputCount);
    }

    @Override
    public Set<PartialPath> getDevicePaths() {
        return new HashSet<PartialPath>(this.devicePathToContextMap.keySet());
    }

    @Override
    public void addDevicePath(PartialPath devicePath, RegionScanNode node) {
        this.devicePathToContextMap.put(devicePath, ((DeviceRegionScanNode)node).devicePathToContextMap.get(devicePath));
    }

    @Override
    public void clearPath() {
        this.devicePathToContextMap = new HashMap<PartialPath, DeviceContext>();
    }

    @Override
    public long getSize() {
        return this.devicePathToContextMap.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceRegionScanNode that = (DeviceRegionScanNode)o;
        return this.devicePathToContextMap.equals(that.devicePathToContextMap) && this.outputCount == that.isOutputCount();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.devicePathToContextMap, this.outputCount);
    }
}

