/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractSortOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.utils.datastructure.SortKey;
import org.apache.iotdb.db.utils.sort.TableDiskSpiller;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableStreamSortOperator
extends AbstractSortOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableStreamSortOperator.class);
    private final Comparator<SortKey> streamSortComparator;
    private final int minLinesToOutput;
    private long remainingCount = 0L;
    private boolean noMoreDataFromChild = false;
    private TsBlock currentTsBlock = null;
    private boolean canStreamOutput = false;
    private SortKey lastRow = null;

    public TableStreamSortOperator(OperatorContext operatorContext, Operator inputOperator, List<TSDataType> dataTypes, String folderPath, Comparator<SortKey> comparator, Comparator<SortKey> streamSortComparator, int minLinesToOutput) {
        super(operatorContext, inputOperator, dataTypes, new TableDiskSpiller(folderPath, folderPath + operatorContext.getOperatorId(), dataTypes), comparator);
        this.streamSortComparator = streamSortComparator;
        this.minLinesToOutput = minLinesToOutput;
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.canStreamOutput || !this.tsBlockBuilder.isEmpty()) {
            this.buildResult();
            if (!this.hasMoreSortedData()) {
                this.canStreamOutput = false;
                this.resetSortRelatedResource();
            }
            if (this.tsBlockBuilder.isFull() || this.consumedUp()) {
                int rowCount = this.tsBlockBuilder.getPositionCount();
                TsBlock res = this.tsBlockBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, rowCount));
                this.remainingCount -= (long)rowCount;
                this.tsBlockBuilder.reset();
                return res;
            }
        }
        if (this.currentTsBlock != null) {
            this.cacheTsBlock(this.currentTsBlock);
            this.currentTsBlock = null;
        }
        long startTime = System.nanoTime();
        if (!this.inputOperator.hasNextWithTimer()) {
            this.noMoreDataFromChild = true;
            this.canStreamOutput = true;
        } else {
            try {
                this.currentTsBlock = this.inputOperator.nextWithTimer();
                if (this.currentTsBlock == null || this.currentTsBlock.isEmpty()) {
                    this.currentTsBlock = null;
                    TsBlock tsBlock = null;
                    return tsBlock;
                }
                this.dataSize += this.currentTsBlock.getSizeInBytes();
                if ((long)this.currentTsBlock.getPositionCount() + this.remainingCount < (long)this.minLinesToOutput) {
                    this.cacheTsBlock(this.currentTsBlock);
                    this.remainingCount += (long)this.currentTsBlock.getPositionCount();
                    this.currentTsBlock = null;
                } else if (this.isStreamCompareKeySame()) {
                    this.cacheTsBlock(this.currentTsBlock);
                    this.remainingCount += (long)this.currentTsBlock.getPositionCount();
                    this.currentTsBlock = null;
                } else {
                    int endIndex = this.getEndIndexFromCurrentTsBlock();
                    if (endIndex == -1 || (long)endIndex + this.remainingCount + 1L < (long)this.minLinesToOutput) {
                        this.cacheTsBlock(this.currentTsBlock);
                        this.remainingCount += (long)this.currentTsBlock.getPositionCount();
                        this.currentTsBlock = null;
                    } else {
                        this.cacheTsBlock(this.currentTsBlock.getRegion(0, endIndex + 1));
                        this.remainingCount += (long)this.currentTsBlock.getPositionCount();
                        this.canStreamOutput = true;
                        this.currentTsBlock = this.currentTsBlock.subTsBlock(endIndex + 1);
                    }
                }
            }
            catch (IoTDBException e) {
                this.clear();
                throw e;
            }
            finally {
                this.prepareUntilReadyCost += System.nanoTime() - startTime;
            }
        }
        return null;
    }

    private boolean consumedUp() {
        return this.remainingCount == (long)this.tsBlockBuilder.getPositionCount() && this.noMoreDataFromChild;
    }

    private int getEndIndexFromCurrentTsBlock() {
        SortKey sortKeyOfLastRow = new SortKey(this.currentTsBlock, this.currentTsBlock.getPositionCount() - 1);
        SortKey sortKeyOfFoundRow = new SortKey(this.currentTsBlock, this.currentTsBlock.getPositionCount() - 2);
        int index = this.currentTsBlock.getPositionCount() - 2;
        while (index >= 0) {
            sortKeyOfFoundRow.rowIndex = index--;
            if (this.streamSortComparator.compare(sortKeyOfFoundRow, sortKeyOfLastRow) == 0) continue;
            return index;
        }
        return -1;
    }

    private boolean isStreamCompareKeySame() {
        return this.lastRow == null || this.streamSortComparator.compare(this.lastRow, new SortKey(this.currentTsBlock, this.currentTsBlock.getPositionCount() - 1)) == 0;
    }

    @Override
    protected void cacheTsBlock(TsBlock tsBlock) throws IoTDBException {
        super.cacheTsBlock(tsBlock);
        this.lastRow = new SortKey(tsBlock, tsBlock.getPositionCount() - 1);
    }

    @Override
    protected void appendTime(TimeColumnBuilder timeBuilder, long time) {
    }

    @Override
    public boolean hasNext() throws Exception {
        return super.hasNext() || !this.tsBlockBuilder.isEmpty() || this.currentTsBlock != null;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.lastRow = null;
        this.currentTsBlock = null;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.inputOperator) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.noMoreData) + this.tsBlockBuilder.getRetainedSizeInBytes();
    }
}

