/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair;

import org.apache.iotdb.library.drepair.util.LsGreedy;
import org.apache.iotdb.library.drepair.util.Screen;
import org.apache.iotdb.library.drepair.util.ValueRepair;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFValueRepair
implements UDTF {
    String method;
    double minSpeed;
    double maxSpeed;
    double center;
    double sigma;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.FLOAT, Type.DOUBLE, Type.INT32, Type.INT64).validate(x -> (Double)x > 0.0, "Parameter $sigma$ should be larger than 0.", (Object)validator.getParameters().getDoubleOrDefault("sigma", 1.0)).validate(params -> (Double)params[0] < (Double)params[1], "parameter $minSpeed$ should be smaller than $maxSpeed$.", validator.getParameters().getDoubleOrDefault("minSpeed", -1.0), validator.getParameters().getDoubleOrDefault("maxSpeed", 1.0));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new SlidingSizeWindowAccessStrategy(Integer.MAX_VALUE)).setOutputDataType(parameters.getDataType(0));
        this.method = parameters.getStringOrDefault("method", "screen");
        this.minSpeed = parameters.getDoubleOrDefault("minSpeed", Double.NaN);
        this.maxSpeed = parameters.getDoubleOrDefault("maxSpeed", Double.NaN);
        this.center = parameters.getDoubleOrDefault("center", 0.0);
        this.sigma = parameters.getDoubleOrDefault("sigma", Double.NaN);
    }

    @Override
    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        ValueRepair vr;
        if ("screen".equalsIgnoreCase(this.method)) {
            Screen screen = new Screen(rowWindow.getRowIterator());
            if (!Double.isNaN(this.minSpeed)) {
                screen.setSmin(this.minSpeed);
            }
            if (!Double.isNaN(this.maxSpeed)) {
                screen.setSmax(this.maxSpeed);
            }
            vr = screen;
        } else if ("lsgreedy".equalsIgnoreCase(this.method)) {
            LsGreedy lsGreedy = new LsGreedy(rowWindow.getRowIterator());
            if (!Double.isNaN(this.sigma)) {
                lsGreedy.setSigma(this.sigma);
            }
            lsGreedy.setCenter(this.center);
            vr = lsGreedy;
        } else {
            throw new UDFException("Illegal method.");
        }
        vr.repair();
        double[] repaired = vr.getRepaired();
        long[] time = vr.getTime();
        switch (rowWindow.getDataType(0)) {
            case DOUBLE: {
                for (int i = 0; i < time.length; ++i) {
                    collector.putDouble(time[i], repaired[i]);
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < time.length; ++i) {
                    collector.putFloat(time[i], (float)repaired[i]);
                }
                break;
            }
            case INT32: {
                for (int i = 0; i < time.length; ++i) {
                    collector.putInt(time[i], (int)Math.round(repaired[i]));
                }
                break;
            }
            case INT64: {
                for (int i = 0; i < time.length; ++i) {
                    collector.putLong(time[i], Math.round(repaired[i]));
                }
                break;
            }
            default: {
                throw new Exception();
            }
        }
    }
}

