/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.specifictype.doubletype;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.Map;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.IntermediateResultOperator;
import org.apache.iotdb.pipe.api.type.Binary;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FractionPoweredSumOperator
implements IntermediateResultOperator {
    private double sum;
    private final transient double power;

    public FractionPoweredSumOperator(double power) {
        this.power = power;
    }

    @Override
    public String getName() {
        return "sum_x" + this.power;
    }

    @Override
    public void configureSystemParameters(Map<String, String> systemParams) {
    }

    @Override
    public boolean initAndGetIsSupport(boolean initialInput, long initialTimestamp) {
        return false;
    }

    @Override
    public boolean initAndGetIsSupport(int initialInput, long initialTimestamp) {
        this.sum = Math.pow(initialInput, this.power);
        return true;
    }

    @Override
    public boolean initAndGetIsSupport(LocalDate initialInput, long initialTimestamp) {
        return false;
    }

    @Override
    public boolean initAndGetIsSupport(long initialInput, long initialTimestamp) {
        this.sum = Math.pow(initialInput, this.power);
        return true;
    }

    @Override
    public boolean initAndGetIsSupport(float initialInput, long initialTimestamp) {
        this.sum = Math.pow(initialInput, this.power);
        return true;
    }

    @Override
    public boolean initAndGetIsSupport(double initialInput, long initialTimestamp) {
        this.sum = Math.pow(initialInput, this.power);
        return true;
    }

    @Override
    public boolean initAndGetIsSupport(String initialInput, long initialTimestamp) {
        return false;
    }

    @Override
    public boolean initAndGetIsSupport(Binary initialInput, long initialTimestamp) {
        return false;
    }

    @Override
    public void updateValue(boolean input, long timestamp) {
        throw new UnsupportedOperationException("FractionPoweredSumOperator does not support boolean input");
    }

    @Override
    public void updateValue(int input, long timestamp) {
        this.sum += Math.pow(input, this.power);
    }

    @Override
    public void updateValue(LocalDate input, long timestamp) {
        throw new UnsupportedOperationException("FractionPoweredSumOperator does not support date input");
    }

    @Override
    public void updateValue(long input, long timestamp) {
        this.sum += Math.pow(input, this.power);
    }

    @Override
    public void updateValue(float input, long timestamp) {
        this.sum += Math.pow(input, this.power);
    }

    @Override
    public void updateValue(double input, long timestamp) {
        this.sum += Math.pow(input, this.power);
    }

    @Override
    public void updateValue(String input, long timestamp) {
        throw new UnsupportedOperationException("FractionPoweredSumOperator does not support string input");
    }

    @Override
    public void updateValue(Binary initialInput, long initialTimestamp) {
        throw new UnsupportedOperationException("FractionPoweredSumOperator does not support binary input");
    }

    @Override
    public Pair<TSDataType, Object> getResult() {
        return new Pair((Object)TSDataType.DOUBLE, (Object)this.sum);
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((double)this.sum, (OutputStream)outputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) throws IOException {
        this.sum = ReadWriteIOUtils.readDouble((ByteBuffer)byteBuffer);
    }
}

