/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.type;

import org.apache.fury.Fury;
import org.apache.fury.type.GenericType;

public class Generics {
    private final Fury fury;
    private int genericTypesSize;
    private GenericType[] genericTypes = new GenericType[16];
    private int[] depths = new int[16];

    public Generics(Fury fury) {
        this.fury = fury;
    }

    public void pushGenericType(GenericType fieldType) {
        int size;
        GenericType[] genericTypes = this.genericTypes;
        if ((size = this.genericTypesSize++) == genericTypes.length) {
            genericTypes = new GenericType[genericTypes.length << 1];
            System.arraycopy(this.genericTypes, 0, genericTypes, 0, size);
            this.genericTypes = genericTypes;
            int[] depthsNew = new int[this.depths.length << 1];
            System.arraycopy(this.depths, 0, depthsNew, 0, size);
            this.depths = depthsNew;
        }
        genericTypes[size] = fieldType;
        this.depths[size] = this.fury.getDepth();
    }

    public void popGenericType() {
        int size = this.genericTypesSize;
        if (size == 0) {
            return;
        }
        if (this.depths[--size] < this.fury.getDepth()) {
            return;
        }
        this.genericTypes[size] = null;
        this.genericTypesSize = size;
    }

    public GenericType nextGenericType() {
        int index = this.genericTypesSize;
        if (index > 0) {
            GenericType genericType = this.genericTypes[--index];
            if (this.depths[index] == this.fury.getDepth() - 1) {
                return genericType;
            }
        }
        return null;
    }
}

