/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.fury.io.FuryStreamReader;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.Platform;

@NotThreadSafe
public class FuryInputStream
extends InputStream
implements FuryStreamReader {
    private final InputStream stream;
    private final int bufferSize;
    private final MemoryBuffer buffer;

    public FuryInputStream(InputStream stream) {
        this(stream, 4096);
    }

    public FuryInputStream(InputStream stream, int bufferSize) {
        this.stream = stream;
        this.bufferSize = bufferSize;
        byte[] bytes = new byte[bufferSize];
        this.buffer = MemoryBuffer.fromByteArray(bytes, 0, 0, this);
    }

    @Override
    public int fillBuffer(int minFillSize) {
        MemoryBuffer buffer = this.buffer;
        byte[] heapMemory = buffer.getHeapMemory();
        int offset = buffer.size();
        if (offset + minFillSize > heapMemory.length) {
            heapMemory = FuryInputStream.growBuffer(minFillSize, buffer);
        }
        try {
            int read;
            int newRead;
            int len = heapMemory.length - offset;
            for (read = this.stream.read(heapMemory, offset, len); read < minFillSize; read += newRead) {
                newRead = this.stream.read(heapMemory, offset + read, len - read);
                if (newRead >= 0) continue;
                throw new IndexOutOfBoundsException("No enough data in the stream " + this.stream);
            }
            buffer.increaseSize(read);
            return read;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] growBuffer(int minFillSize, MemoryBuffer buffer) {
        int targetSize = buffer.size() + minFillSize;
        int newSize = targetSize < 0x6400000 ? targetSize << 2 : (int)Math.min((double)targetSize * 1.5, 2.147483639E9);
        byte[] newBuffer = new byte[newSize];
        byte[] heapMemory = buffer.getHeapMemory();
        System.arraycopy(heapMemory, 0, newBuffer, 0, buffer.size());
        buffer.initHeapBuffer(newBuffer, 0, buffer.size());
        heapMemory = newBuffer;
        return heapMemory;
    }

    @Override
    public void readTo(byte[] dst, int dstIndex, int len) {
        MemoryBuffer buf = this.buffer;
        int remaining = buf.remaining();
        if (remaining >= len) {
            buf.readBytes(dst, dstIndex, len);
        } else {
            buf.readBytes(dst, dstIndex, remaining);
            len -= remaining;
            dstIndex += remaining;
            try {
                int newRead;
                for (int read = this.stream.read(dst, dstIndex, len); read < len; read += newRead) {
                    newRead = this.stream.read(dst, dstIndex + read, len - read);
                    if (newRead >= 0) continue;
                    throw new IndexOutOfBoundsException("No enough data in the stream " + this.stream);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void readToUnsafe(Object target, long targetPointer, int numBytes) {
        MemoryBuffer buf = this.buffer;
        int remaining = buf.remaining();
        if (remaining < numBytes) {
            this.fillBuffer(numBytes - remaining);
        }
        byte[] heapMemory = buf.getHeapMemory();
        long address = buf.getUnsafeReaderAddress();
        Platform.copyMemory(heapMemory, address, target, targetPointer, numBytes);
        buf.increaseReaderIndex(numBytes);
    }

    @Override
    public void readToByteBuffer(ByteBuffer dst, int length) {
        MemoryBuffer buf = this.buffer;
        int remaining = buf.remaining();
        if (remaining < length) {
            this.fillBuffer(length - remaining);
        }
        byte[] heapMemory = buf.getHeapMemory();
        dst.put(heapMemory, buf._unsafeHeapReaderIndex(), length);
        buf.increaseReaderIndex(length);
    }

    @Override
    public int readToByteBuffer(ByteBuffer dst) {
        int len;
        MemoryBuffer buf = this.buffer;
        int remaining = buf.remaining();
        if (remaining >= (len = dst.remaining())) {
            buf.read(dst, len);
            return len;
        }
        try {
            buf.read(dst, remaining);
            int available = this.stream.available();
            if (available > 0) {
                this.fillBuffer(available);
                int newRemaining = buf.remaining();
                buf.read(dst, newRemaining);
                return newRemaining + remaining;
            }
            return remaining;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MemoryBuffer getBuffer() {
        return this.buffer;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public void shrinkBuffer() {
        int bufferSize;
        int remaining = this.buffer.remaining();
        if (remaining > (bufferSize = this.bufferSize) || this.buffer.size() > bufferSize) {
            byte[] heapMemory = this.buffer.getHeapMemory();
            byte[] newBuffer = new byte[Math.max(bufferSize, remaining)];
            System.arraycopy(heapMemory, this.buffer.readerIndex(), newBuffer, 0, remaining);
            this.buffer.initHeapBuffer(newBuffer, 0, remaining);
            this.buffer.readerIndex(0);
        }
    }

    @Override
    public int read() throws IOException {
        MemoryBuffer buf = this.buffer;
        if (buf.remaining() > 0) {
            return buf.readByte() & 0xFF;
        }
        int available = this.stream.available();
        if (available > 0) {
            this.fillBuffer(1);
            return buf.readByte() & 0xFF;
        }
        return this.stream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        MemoryBuffer buf = this.buffer;
        int remaining = buf.remaining();
        if (remaining >= len) {
            buf.readBytes(b, off, len);
            return len;
        }
        buf.readBytes(b, off, remaining);
        return this.stream.read(b, off + remaining, len - remaining) + remaining;
    }

    @Override
    public long skip(long n) throws IOException {
        MemoryBuffer buf = this.buffer;
        int remaining = buf.remaining();
        if ((long)remaining >= n) {
            buf.increaseReaderIndex((int)n);
            return n;
        }
        buf.increaseReaderIndex(remaining);
        return this.stream.skip(n - (long)remaining) + (long)remaining;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining() + this.stream.available();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

