/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.collection;

import org.apache.fury.collection.MapStatistics;
import org.apache.fury.collection.ObjectIntMap;

public final class IdentityObjectIntMap<K>
extends ObjectIntMap<K> {
    private MapStatistics stat = new MapStatistics();

    public IdentityObjectIntMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    protected int place(K item) {
        return System.identityHashCode(item) & this.mask;
    }

    @Override
    int locateKey(K key) {
        Object[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        Object other;
        while ((other = keyTable[i]) != null) {
            if (other == key) {
                return i;
            }
            i = i + 1 & mask;
        }
        return -(i + 1);
    }

    @Override
    public int get(K key, int defaultValue) {
        Object[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        Object other;
        while ((other = keyTable[i]) != null) {
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public void put(K key, int value) {
        Object[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        while (true) {
            Object other;
            if ((other = keyTable[i]) == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                if (++this.size >= this.threshold) {
                    this.resize(keyTable.length << 1);
                }
                return;
            }
            if (other == key) {
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & mask;
        }
    }

    public int putOrGet(K key, int value) {
        Object[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        while (true) {
            Object other;
            if ((other = keyTable[i]) == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                if (++this.size >= this.threshold) {
                    this.resize(keyTable.length << 1);
                }
                return Integer.MIN_VALUE;
            }
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & mask;
        }
    }

    public int profilingPutOrGet(K key, int value) {
        Object[] keyTable = this.keyTable;
        int mask = this.mask;
        int i = this.place(key);
        while (true) {
            ++this.stat.totalProbeProfiled;
            Object other = keyTable[i];
            if (other == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                if (++this.size >= this.threshold) {
                    this.resize(keyTable.length << 1);
                }
                int probed = this.stat.totalProbeProfiled - this.stat.lastProbeProfiled;
                this.stat.maxProbeProfiled = Math.max(probed, this.stat.maxProbeProfiled);
                this.stat.lastProbeProfiled = this.stat.totalProbeProfiled;
                return Integer.MIN_VALUE;
            }
            if (other == key) {
                int probed = this.stat.totalProbeProfiled - this.stat.lastProbeProfiled;
                this.stat.maxProbeProfiled = Math.max(probed, this.stat.maxProbeProfiled);
                this.stat.lastProbeProfiled = this.stat.totalProbeProfiled;
                return this.valueTable[i];
            }
            i = i + 1 & mask;
        }
    }

    public MapStatistics getAndResetStatistics() {
        MapStatistics result = this.stat;
        this.stat = new MapStatistics();
        return result;
    }

    @Override
    public int hashCode() {
        int h = this.size;
        Object[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            Object key = keyTable[i];
            if (key == null) continue;
            h += System.identityHashCode(key) + valueTable[i];
        }
        return h;
    }
}

