/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.protobuf.convertor;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.core.protocol.AbstractMessage;
import org.apache.seata.core.protocol.MergedWarpMessage;
import org.apache.seata.serializer.protobuf.convertor.PbConvertor;
import org.apache.seata.serializer.protobuf.generated.AbstractMessageProto;
import org.apache.seata.serializer.protobuf.generated.MergedWarpMessageProto;
import org.apache.seata.serializer.protobuf.generated.MessageTypeProto;
import org.apache.seata.serializer.protobuf.manager.ProtobufConvertManager;

public class MergedWarpMessageConvertor
implements PbConvertor<MergedWarpMessage, MergedWarpMessageProto> {
    @Override
    public MergedWarpMessageProto convert2Proto(MergedWarpMessage mergedWarpMessage) {
        short typeCode = mergedWarpMessage.getTypeCode();
        AbstractMessageProto abstractMessage = AbstractMessageProto.newBuilder().setMessageType(MessageTypeProto.forNumber(typeCode)).build();
        ArrayList<Any> lists = new ArrayList<Any>();
        for (AbstractMessage msg : mergedWarpMessage.msgs) {
            PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchConvertor(msg.getClass().getName());
            lists.add(Any.pack((Message)((Message)pbConvertor.convert2Proto(msg))));
        }
        MergedWarpMessageProto mergedWarpMessageProto = MergedWarpMessageProto.newBuilder().setAbstractMessage(abstractMessage).addAllMsgs(lists).addAllMsgIds(mergedWarpMessage.msgIds).build();
        return mergedWarpMessageProto;
    }

    @Override
    public MergedWarpMessage convert2Model(MergedWarpMessageProto mergedWarpMessageProto) {
        MergedWarpMessage result = new MergedWarpMessage();
        List<Any> anys = mergedWarpMessageProto.getMsgsList();
        for (Any any : anys) {
            Class clazz;
            if (!any.is(clazz = ProtobufConvertManager.getInstance().fetchProtoClass(MergedWarpMessageConvertor.getTypeNameFromTypeUrl(any.getTypeUrl())))) continue;
            try {
                Message ob = any.unpack(clazz);
                PbConvertor pbConvertor = ProtobufConvertManager.getInstance().fetchReversedConvertor(clazz.getName());
                Object model = pbConvertor.convert2Model(ob);
                result.msgs.add((AbstractMessage)model);
            }
            catch (InvalidProtocolBufferException e) {
                throw new ShouldNeverHappenException((Throwable)e);
            }
        }
        result.msgIds = mergedWarpMessageProto.getMsgIdsList();
        return result;
    }

    private static String getTypeNameFromTypeUrl(String typeUrl) {
        int pos = typeUrl.lastIndexOf(47);
        return pos == -1 ? "" : typeUrl.substring(pos + 1);
    }
}

