/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.db.store;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.store.MappingDO;
import org.apache.seata.core.store.db.DataSourceProvider;
import org.apache.seata.server.storage.db.store.VGroupMappingDataBaseDAO;
import org.apache.seata.server.store.VGroupMappingStoreManager;

@LoadLevel(name="db")
public class DataBaseVGroupMappingStoreManager
implements VGroupMappingStoreManager {
    protected VGroupMappingDataBaseDAO vGroupMappingDataBaseDAO;
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();

    public DataBaseVGroupMappingStoreManager() {
        String datasourceType = CONFIG.getConfig("store.db.datasource");
        DataSource vGroupMappingDataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)datasourceType)).provide();
        this.vGroupMappingDataBaseDAO = new VGroupMappingDataBaseDAO(vGroupMappingDataSource);
    }

    public boolean addVGroup(MappingDO mappingDO) {
        return this.vGroupMappingDataBaseDAO.insertMappingDO(mappingDO);
    }

    public boolean removeVGroup(String vGroup) {
        return this.vGroupMappingDataBaseDAO.deleteMappingDOByVGroup(vGroup);
    }

    public Map<String, Object> loadVGroups() {
        List mappingDOS = this.vGroupMappingDataBaseDAO.queryMappingDO();
        Instance instance = Instance.getInstance();
        HashMap<String, Object> mappings = new HashMap<String, Object>();
        for (MappingDO mappingDO : mappingDOS) {
            if (mappingDO.getCluster() == null || !mappingDO.getCluster().equals(instance.getClusterName())) continue;
            mappings.put(mappingDO.getVGroup(), null);
        }
        return mappings;
    }
}

