/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.instance;

import javax.annotation.Resource;
import org.apache.seata.common.XID;
import org.apache.seata.common.holder.ObjectHolder;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.server.cluster.listener.ClusterChangeEvent;
import org.apache.seata.server.cluster.listener.ClusterChangeListener;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.RaftStateMachine;
import org.apache.seata.server.instance.AbstractSeataInstanceStrategy;
import org.apache.seata.server.instance.SeataInstanceStrategy;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.store.StoreConfig;
import org.apache.seata.spring.boot.autoconfigure.properties.server.raft.ServerRaftProperties;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.scheduling.annotation.Async;

public class RaftServerInstanceStrategy
extends AbstractSeataInstanceStrategy
implements ClusterChangeListener,
Ordered {
    @Resource
    ServerRaftProperties raftProperties;

    public Instance serverInstanceInit() {
        ConfigurableEnvironment environment = (ConfigurableEnvironment)ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment");
        Instance instance = Instance.getInstance();
        String namespace = this.registryNamingServerProperties.getNamespace();
        instance.setNamespace(namespace);
        String clusterName = this.registryNamingServerProperties.getCluster();
        instance.setClusterName(clusterName);
        String unit = this.raftProperties.getGroup();
        instance.setUnit(unit);
        String clusterType = String.valueOf(StoreConfig.getSessionMode());
        instance.addMetadata("cluster-type", (Object)("raft".equalsIgnoreCase(clusterType) ? clusterType : "default"));
        RaftStateMachine stateMachine = RaftServerManager.getRaftServer((String)unit).getRaftStateMachine();
        long term = RaftServerManager.getRaftServer((String)unit).getRaftStateMachine().getCurrentTerm().get();
        instance.setTerm(term);
        instance.setRole(stateMachine.isLeader() ? ClusterRole.LEADER : ClusterRole.FOLLOWER);
        instance.setControl(new Node.Endpoint(XID.getIpAddress(), this.serverProperties.getPort().intValue(), "http"));
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                if (!propertyName.startsWith("seata.registry.metadata.")) continue;
                instance.addMetadata(propertyName.substring("seata.registry.metadata.".length()), enumerablePropertySource.getProperty(propertyName));
            }
        }
        return instance;
    }

    public SeataInstanceStrategy.Type type() {
        return SeataInstanceStrategy.Type.RAFT;
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    @EventListener
    @Async
    public void onChangeEvent(ClusterChangeEvent event) {
        Instance instance = Instance.getInstance();
        instance.setTerm(event.getTerm());
        instance.setRole(event.isLeader() ? ClusterRole.LEADER : ClusterRole.FOLLOWER);
        SessionHolder.getRootVGroupMappingManager().notifyMapping();
    }
}

