/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft.util;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.entity.Task;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.seata.core.exception.GlobalTransactionException;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.context.SeataClusterContext;
import org.apache.seata.server.cluster.raft.sync.RaftSyncMessageSerializer;
import org.apache.seata.server.cluster.raft.sync.msg.RaftSyncMessage;

/*
 * Exception performing whole class analysis ignored.
 */
public class RaftTaskUtil {
    public static boolean createTask(Closure done, Object data, CompletableFuture<Boolean> completableFuture) throws TransactionException {
        Task task = new Task();
        if (data != null) {
            RaftSyncMessage raftSyncMessage = new RaftSyncMessage();
            raftSyncMessage.setBody(data);
            try {
                task.setData(ByteBuffer.wrap(RaftSyncMessageSerializer.encode((RaftSyncMessage)raftSyncMessage)));
            }
            catch (IOException e) {
                throw new TransactionException((Throwable)e);
            }
        }
        task.setDone(done == null ? status -> {} : done);
        RaftServerManager.getRaftServer((String)SeataClusterContext.getGroup()).getNode().apply(task);
        if (completableFuture != null) {
            return RaftTaskUtil.futureGet(completableFuture);
        }
        return true;
    }

    public static boolean createTask(Closure done, CompletableFuture<Boolean> completableFuture) throws TransactionException {
        return RaftTaskUtil.createTask((Closure)done, null, completableFuture);
    }

    public static boolean futureGet(CompletableFuture<Boolean> completableFuture) throws TransactionException {
        try {
            return completableFuture.get();
        }
        catch (InterruptedException e) {
            throw new GlobalTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to store global session: " + e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            throw new GlobalTransactionException(TransactionExceptionCode.FailedWriteSession, "Fail to store global session: " + e.getMessage());
        }
    }
}

