/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.spring.boot.autoconfigure.loader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.seata.common.holder.ObjectHolder;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.FileConfiguration;
import org.apache.seata.config.file.FileConfig;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@Order(value=-2147483648)
public class SeataPropertiesLoader
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    List<String> prefixList = Arrays.asList("config.", "registry.", "server.", "store.", "metrics.", "transport.");

    public void initialize(ConfigurableApplicationContext applicationContext) {
        FileConfiguration configuration;
        FileConfig fileConfig;
        Map configs;
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment") == null) {
            ObjectHolder.INSTANCE.setObject("springConfigurableEnvironment", (Object)applicationContext.getEnvironment());
        }
        if (CollectionUtils.isNotEmpty((Map)(configs = (fileConfig = (configuration = ConfigurationFactory.getOriginFileInstanceRegistry()).getFileConfig()).getAllConfig()))) {
            Optional originFileInstance = ConfigurationFactory.getOriginFileInstance();
            originFileInstance.ifPresent(fileConfiguration -> configs.putAll(fileConfiguration.getFileConfig().getAllConfig()));
            Properties properties = new Properties();
            configs.forEach((k, v) -> {
                if (v instanceof String && StringUtils.isEmpty((CharSequence)((String)v))) {
                    return;
                }
                if (this.prefixList.stream().anyMatch(k::startsWith)) {
                    properties.put("seata." + k, v);
                }
            });
            environment.getPropertySources().addLast((PropertySource)new PropertiesPropertySource("seataOldConfig", properties));
        }
        this.loadSessionAndLockModes();
    }

    public void loadSessionAndLockModes() {
        try {
            Class<?> storeConfigClass = Class.forName("org.apache.seata.server.store.StoreConfig");
            Optional<String> sessionMode = this.invokeEnumMethod(storeConfigClass, "getSessionMode", "getName");
            Optional<String> lockMode = this.invokeEnumMethod(storeConfigClass, "getLockMode", "getName");
            sessionMode.ifPresent(value -> System.setProperty("sessionMode", value));
            lockMode.ifPresent(value -> System.setProperty("lockMode", value));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private Optional<String> invokeEnumMethod(Class<?> clazz, String enumMethodName, String getterMethodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method enumMethod = clazz.getMethod(enumMethodName, new Class[0]);
        Object enumValue = enumMethod.invoke(null, new Object[0]);
        if (enumValue != null) {
            Method getterMethod = enumValue.getClass().getMethod(getterMethodName, new Class[0]);
            return Optional.ofNullable((String)getterMethod.invoke(enumValue, new Object[0]));
        }
        return Optional.empty();
    }
}

