/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.service.auth.PersistedPolarisPrincipal;
import org.immutables.value.Generated;

@Generated(from="PersistedPolarisPrincipal", generator="Immutables")
final class ImmutablePersistedPolarisPrincipal
extends PersistedPolarisPrincipal {
    private final ImmutableSet<String> roles;
    private final PrincipalEntity entity;
    private final transient String name;
    private final transient long id;
    private transient int hashCode;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long PROPERTIES_LAZY_INIT_BIT = 1L;
    private transient Map<String, String> properties;

    private ImmutablePersistedPolarisPrincipal(ImmutableSet<String> roles, PrincipalEntity entity) {
        this.roles = roles;
        this.entity = entity;
        this.name = this.initShim.getName();
        this.id = this.initShim.getId();
        this.initShim = null;
    }

    public ImmutableSet<String> getRoles() {
        return this.roles;
    }

    @Override
    PrincipalEntity getEntity() {
        return this.entity;
    }

    @Override
    public String getName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getName() : this.name;
    }

    @Override
    public long getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    public final ImmutablePersistedPolarisPrincipal withRoles(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutablePersistedPolarisPrincipal((ImmutableSet<String>)newValue, this.entity);
    }

    public final ImmutablePersistedPolarisPrincipal withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutablePersistedPolarisPrincipal((ImmutableSet<String>)newValue, this.entity);
    }

    public final ImmutablePersistedPolarisPrincipal withEntity(PrincipalEntity value) {
        if (this.entity == value) {
            return this;
        }
        PrincipalEntity newValue = Objects.requireNonNull(value, "entity");
        return new ImmutablePersistedPolarisPrincipal(this.roles, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePersistedPolarisPrincipal && this.equalsByValue((ImmutablePersistedPolarisPrincipal)another);
    }

    private boolean equalsByValue(ImmutablePersistedPolarisPrincipal another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.roles.equals(another.roles) && this.entity.equals((Object)another.entity) && this.name.equals(another.name) && this.id == another.id;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.entity.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.id);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PersistedPolarisPrincipal").omitNullValues().add("roles", this.roles).add("entity", (Object)this.entity).add("name", (Object)this.name).add("id", this.id).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getProperties() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutablePersistedPolarisPrincipal immutablePersistedPolarisPrincipal = this;
            synchronized (immutablePersistedPolarisPrincipal) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.properties = Objects.requireNonNull(super.getProperties(), "properties");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.properties;
    }

    public static ImmutablePersistedPolarisPrincipal copyOf(PersistedPolarisPrincipal instance) {
        if (instance instanceof ImmutablePersistedPolarisPrincipal) {
            return (ImmutablePersistedPolarisPrincipal)instance;
        }
        return ImmutablePersistedPolarisPrincipal.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutablePersistedPolarisPrincipal.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PersistedPolarisPrincipal", generator="Immutables")
    private final class InitShim {
        private byte nameBuildStage = 0;
        private String name;
        private byte idBuildStage = 0;
        private long id;

        private InitShim() {
        }

        String getName() {
            if (this.nameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = (byte)-1;
                String computedValue = ImmutablePersistedPolarisPrincipal.super.getName();
                this.name = Objects.requireNonNull(computedValue, "name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        long getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                long computedValue;
                this.idBuildStage = (byte)-1;
                this.id = computedValue = ImmutablePersistedPolarisPrincipal.super.getId();
                this.idBuildStage = 1;
            }
            return this.id;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            return "Cannot build PersistedPolarisPrincipal, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="PersistedPolarisPrincipal", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ENTITY = 1L;
        private long initBits = 1L;
        private ImmutableSet.Builder<String> roles = ImmutableSet.builder();
        private PrincipalEntity entity;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PolarisPrincipal instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PersistedPolarisPrincipal instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            PolarisPrincipal instance;
            long bits = 0L;
            if (object instanceof PolarisPrincipal) {
                instance = (PolarisPrincipal)object;
                if ((bits & 1L) == 0L) {
                    this.addAllRoles(instance.getRoles());
                    bits |= 1L;
                }
            }
            if (object instanceof PersistedPolarisPrincipal) {
                instance = (PersistedPolarisPrincipal)object;
                this.entity(instance.getEntity());
                if ((bits & 1L) == 0L) {
                    this.addAllRoles(instance.getRoles());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder addRole(String element) {
            this.roles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String ... elements) {
            this.roles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(Iterable<String> elements) {
            this.roles = ImmutableSet.builder();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<String> elements) {
            this.roles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entity(PrincipalEntity entity) {
            this.entity = Objects.requireNonNull(entity, "entity");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 1L;
            this.roles = ImmutableSet.builder();
            this.entity = null;
            return this;
        }

        public ImmutablePersistedPolarisPrincipal build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePersistedPolarisPrincipal((ImmutableSet<String>)this.roles.build(), this.entity);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entity");
            }
            return "Cannot build PersistedPolarisPrincipal, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

