/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.mysql;

public class MysqlUtil {
    public static String escapeAndWrapString(String value) {
        return MysqlUtil.escapeString(value, true);
    }

    public static String escapeString(String value) {
        return MysqlUtil.escapeString(value, false);
    }

    private static String escapeString(String value, boolean wrap) {
        int length = value.length();
        if (!MysqlUtil.isEscapeNeededForString(value, length)) {
            if (!wrap) {
                return value;
            }
            StringBuilder buf = new StringBuilder(length + 2);
            buf.append('\'').append(value).append('\'');
            return buf.toString();
        }
        StringBuilder buffer = new StringBuilder((int)((double)length * 1.1));
        if (wrap) {
            buffer.append('\'');
        }
        block9: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\u0000': {
                    buffer.append('\\');
                    buffer.append('0');
                    continue block9;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block9;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block9;
                }
                case '\u001a': {
                    buffer.append('\\');
                    buffer.append('Z');
                    continue block9;
                }
                case '\"': {
                    buffer.append('\"');
                    continue block9;
                }
                case '\'': {
                    buffer.append('\\');
                    buffer.append('\'');
                    continue block9;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block9;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        if (wrap) {
            buffer.append('\'');
        }
        return buffer.toString();
    }

    public static boolean isEscapeNeededForString(String sql, int length) {
        boolean needsEscape = false;
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            switch (c) {
                case '\u0000': {
                    needsEscape = true;
                    break;
                }
                case '\n': {
                    needsEscape = true;
                    break;
                }
                case '\r': {
                    needsEscape = true;
                    break;
                }
                case '\u001a': {
                    needsEscape = true;
                    break;
                }
                case '\'': {
                    needsEscape = true;
                    break;
                }
                case '\\': {
                    needsEscape = true;
                    break;
                }
            }
            if (needsEscape) break;
        }
        return needsEscape;
    }
}

